/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.Angle;
import com.highmobility.value.Bytes;

public class Offroad {
    public static final int IDENTIFIER = 82;
    public static final byte PROPERTY_ROUTE_INCLINE = 1;
    public static final byte PROPERTY_WHEEL_SUSPENSION = 2;

    public static class State
    extends SetCommand {
        Property<Angle> routeIncline = new Property<Angle>(Angle.class, 1);
        Property<Double> wheelSuspension = new Property<Double>(Double.class, 2);

        public Property<Angle> getRouteIncline() {
            return this.routeIncline;
        }

        public Property<Double> getWheelSuspension() {
            return this.wheelSuspension;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.routeIncline.update(p);
                        }
                        case 2: {
                            return this.wheelSuspension.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(82);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setRouteIncline(Property<Angle> routeIncline) {
                Property<Angle> property = routeIncline.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setWheelSuspension(Property<Double> wheelSuspension) {
                Property<Double> property = wheelSuspension.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)82, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)82, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 82);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)82, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)82, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(82);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(82, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(82, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

