/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.value.Bytes;
import java.util.Calendar;
import javax.annotation.Nullable;

public class ParkingTicket {
    public static final int IDENTIFIER = 71;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_OPERATOR_NAME = 2;
    public static final byte PROPERTY_OPERATOR_TICKET_ID = 3;
    public static final byte PROPERTY_TICKET_START_TIME = 4;
    public static final byte PROPERTY_TICKET_END_TIME = 5;

    public static enum Status implements ByteEnum
    {
        ENDED(0),
        STARTED(1);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);
        Property<String> operatorName = new Property<String>(String.class, 2);
        Property<String> operatorTicketID = new Property<String>(String.class, 3);
        Property<Calendar> ticketStartTime = new Property<Calendar>(Calendar.class, 4);
        Property<Calendar> ticketEndTime = new Property<Calendar>(Calendar.class, 5);

        public Property<Status> getStatus() {
            return this.status;
        }

        public Property<String> getOperatorName() {
            return this.operatorName;
        }

        public Property<String> getOperatorTicketID() {
            return this.operatorTicketID;
        }

        public Property<Calendar> getTicketStartTime() {
            return this.ticketStartTime;
        }

        public Property<Calendar> getTicketEndTime() {
            return this.ticketEndTime;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.operatorName.update(p);
                        }
                        case 3: {
                            return this.operatorTicketID.update(p);
                        }
                        case 4: {
                            return this.ticketStartTime.update(p);
                        }
                        case 5: {
                            return this.ticketEndTime.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(71);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<Status> status) {
                Property<Status> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setOperatorName(Property<String> operatorName) {
                Property<String> property = operatorName.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setOperatorTicketID(Property<String> operatorTicketID) {
                Property<String> property = operatorTicketID.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setTicketStartTime(Property<Calendar> ticketStartTime) {
                Property<Calendar> property = ticketStartTime.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setTicketEndTime(Property<Calendar> ticketEndTime) {
                Property<Calendar> property = ticketEndTime.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class EndParking
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);

        public EndParking() {
            super(71);
            this.addProperty(this.status.addValueComponent(new Bytes("00")));
            this.createBytes();
        }

        EndParking(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null || !this.status.getValueComponent().getValueBytes().equals((Object)"00")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartParking
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);
        Property<String> operatorName = new Property<String>(String.class, 2);
        Property<String> operatorTicketID = new Property<String>(String.class, 3);
        Property<Calendar> ticketStartTime = new Property<Calendar>(Calendar.class, 4);
        Property<Calendar> ticketEndTime = new Property<Calendar>(Calendar.class, 5);

        public Property<String> getOperatorName() {
            return this.operatorName;
        }

        public Property<String> getOperatorTicketID() {
            return this.operatorTicketID;
        }

        public Property<Calendar> getTicketStartTime() {
            return this.ticketStartTime;
        }

        public Property<Calendar> getTicketEndTime() {
            return this.ticketEndTime;
        }

        public StartParking(@Nullable String operatorName, String operatorTicketID, Calendar ticketStartTime, @Nullable Calendar ticketEndTime) {
            super(71);
            this.addProperty(this.status.addValueComponent(new Bytes("01")));
            this.addProperty(this.operatorName.update(operatorName));
            this.addProperty(this.operatorTicketID.update(operatorTicketID));
            this.addProperty(this.ticketStartTime.update(ticketStartTime));
            this.addProperty(this.ticketEndTime.update(ticketEndTime));
            this.createBytes();
        }

        StartParking(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            this.status.update(p);
                        }
                        case 2: {
                            return this.operatorName.update(p);
                        }
                        case 3: {
                            return this.operatorTicketID.update(p);
                        }
                        case 4: {
                            return this.ticketStartTime.update(p);
                        }
                        case 5: {
                            return this.ticketEndTime.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null || !this.status.getValueComponent().getValueBytes().equals((Object)"01") || this.operatorTicketID.getValue() == null || this.ticketStartTime.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetParkingTicketProperties
    extends GetCommand<State> {
        public GetParkingTicketProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)71, propertyIdentifiers);
        }

        public GetParkingTicketProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)71, new Bytes(propertyIdentifiers));
        }

        GetParkingTicketProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetParkingTicket
    extends GetCommand<State> {
        public GetParkingTicket() {
            super(State.class, 71);
        }

        public GetParkingTicket(Bytes propertyIdentifiers) {
            super(State.class, (Integer)71, propertyIdentifiers);
        }

        public GetParkingTicket(byte ... propertyIdentifiers) {
            super(State.class, (Integer)71, new Bytes(propertyIdentifiers));
        }

        GetParkingTicket(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetParkingTicketAvailability
    extends GetAvailabilityCommand {
        public GetParkingTicketAvailability() {
            super(71);
        }

        public GetParkingTicketAvailability(Bytes propertyIdentifiers) {
            super(71, propertyIdentifiers);
        }

        public GetParkingTicketAvailability(byte ... propertyIdentifiers) {
            super(71, new Bytes(propertyIdentifiers));
        }

        GetParkingTicketAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

