/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class RooftopControl {
    public static final int IDENTIFIER = 37;
    public static final byte PROPERTY_DIMMING = 1;
    public static final byte PROPERTY_POSITION = 2;
    public static final byte PROPERTY_CONVERTIBLE_ROOF_STATE = 3;
    public static final byte PROPERTY_SUNROOF_TILT_STATE = 4;
    public static final byte PROPERTY_SUNROOF_STATE = 5;
    public static final byte PROPERTY_SUNROOF_RAIN_EVENT = 6;
    public static final byte PROPERTY_TILT_POSITION = 7;

    public static enum SunroofRainEvent implements ByteEnum
    {
        NO_EVENT(0),
        IN_STROKE_POSITION_BECAUSE_OF_RAIN(1),
        AUTOMATICALLY_IN_STROKE_POSITION(2),
        TIMER(3);

        private final byte value;

        public static SunroofRainEvent fromByte(byte byteValue) throws CommandParseException {
            SunroofRainEvent[] values = SunroofRainEvent.values();
            for (int i = 0; i < values.length; ++i) {
                SunroofRainEvent state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SunroofRainEvent.class.getSimpleName(), byteValue));
        }

        private SunroofRainEvent(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum SunroofState implements ByteEnum
    {
        CLOSED(0),
        OPEN(1),
        INTERMEDIATE(2);

        private final byte value;

        public static SunroofState fromByte(byte byteValue) throws CommandParseException {
            SunroofState[] values = SunroofState.values();
            for (int i = 0; i < values.length; ++i) {
                SunroofState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SunroofState.class.getSimpleName(), byteValue));
        }

        private SunroofState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum SunroofTiltState implements ByteEnum
    {
        CLOSED(0),
        TILTED(1),
        HALF_TILTED(2);

        private final byte value;

        public static SunroofTiltState fromByte(byte byteValue) throws CommandParseException {
            SunroofTiltState[] values = SunroofTiltState.values();
            for (int i = 0; i < values.length; ++i) {
                SunroofTiltState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SunroofTiltState.class.getSimpleName(), byteValue));
        }

        private SunroofTiltState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ConvertibleRoofState implements ByteEnum
    {
        CLOSED(0),
        OPEN(1),
        EMERGENCY_LOCKED(2),
        CLOSED_SECURED(3),
        OPEN_SECURED(4),
        HARD_TOP_MOUNTED(5),
        INTERMEDIATE_POSITION(6),
        LOADING_POSITION(7),
        LOADING_POSITION_IMMEDIATE(8);

        private final byte value;

        public static ConvertibleRoofState fromByte(byte byteValue) throws CommandParseException {
            ConvertibleRoofState[] values = ConvertibleRoofState.values();
            for (int i = 0; i < values.length; ++i) {
                ConvertibleRoofState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ConvertibleRoofState.class.getSimpleName(), byteValue));
        }

        private ConvertibleRoofState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Double> dimming = new Property<Double>(Double.class, 1);
        Property<Double> position = new Property<Double>(Double.class, 2);
        Property<ConvertibleRoofState> convertibleRoofState = new Property<ConvertibleRoofState>(ConvertibleRoofState.class, 3);
        Property<SunroofTiltState> sunroofTiltState = new Property<SunroofTiltState>(SunroofTiltState.class, 4);
        Property<SunroofState> sunroofState = new Property<SunroofState>(SunroofState.class, 5);
        Property<SunroofRainEvent> sunroofRainEvent = new Property<SunroofRainEvent>(SunroofRainEvent.class, 6);
        Property<Double> tiltPosition = new Property<Double>(Double.class, 7);

        public Property<Double> getDimming() {
            return this.dimming;
        }

        public Property<Double> getPosition() {
            return this.position;
        }

        public Property<ConvertibleRoofState> getConvertibleRoofState() {
            return this.convertibleRoofState;
        }

        public Property<SunroofTiltState> getSunroofTiltState() {
            return this.sunroofTiltState;
        }

        public Property<SunroofState> getSunroofState() {
            return this.sunroofState;
        }

        public Property<SunroofRainEvent> getSunroofRainEvent() {
            return this.sunroofRainEvent;
        }

        public Property<Double> getTiltPosition() {
            return this.tiltPosition;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.dimming.update(p);
                        }
                        case 2: {
                            return this.position.update(p);
                        }
                        case 3: {
                            return this.convertibleRoofState.update(p);
                        }
                        case 4: {
                            return this.sunroofTiltState.update(p);
                        }
                        case 5: {
                            return this.sunroofState.update(p);
                        }
                        case 6: {
                            return this.sunroofRainEvent.update(p);
                        }
                        case 7: {
                            return this.tiltPosition.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(37);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setDimming(Property<Double> dimming) {
                Property<Double> property = dimming.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setPosition(Property<Double> position) {
                Property<Double> property = position.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setConvertibleRoofState(Property<ConvertibleRoofState> convertibleRoofState) {
                Property<ConvertibleRoofState> property = convertibleRoofState.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setSunroofTiltState(Property<SunroofTiltState> sunroofTiltState) {
                Property<SunroofTiltState> property = sunroofTiltState.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setSunroofState(Property<SunroofState> sunroofState) {
                Property<SunroofState> property = sunroofState.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setSunroofRainEvent(Property<SunroofRainEvent> sunroofRainEvent) {
                Property<SunroofRainEvent> property = sunroofRainEvent.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setTiltPosition(Property<Double> tiltPosition) {
                Property<Double> property = tiltPosition.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ControlRooftop
    extends SetCommand {
        Property<Double> dimming = new Property<Double>(Double.class, 1);
        Property<Double> position = new Property<Double>(Double.class, 2);
        Property<ConvertibleRoofState> convertibleRoofState = new Property<ConvertibleRoofState>(ConvertibleRoofState.class, 3);
        Property<SunroofTiltState> sunroofTiltState = new Property<SunroofTiltState>(SunroofTiltState.class, 4);
        Property<SunroofState> sunroofState = new Property<SunroofState>(SunroofState.class, 5);

        public Property<Double> getDimming() {
            return this.dimming;
        }

        public Property<Double> getPosition() {
            return this.position;
        }

        public Property<ConvertibleRoofState> getConvertibleRoofState() {
            return this.convertibleRoofState;
        }

        public Property<SunroofTiltState> getSunroofTiltState() {
            return this.sunroofTiltState;
        }

        public Property<SunroofState> getSunroofState() {
            return this.sunroofState;
        }

        public ControlRooftop(@Nullable Double dimming, @Nullable Double position, @Nullable ConvertibleRoofState convertibleRoofState, @Nullable SunroofTiltState sunroofTiltState, @Nullable SunroofState sunroofState) {
            super(37);
            this.addProperty(this.dimming.update(dimming));
            this.addProperty(this.position.update(position));
            if (convertibleRoofState == ConvertibleRoofState.EMERGENCY_LOCKED || convertibleRoofState == ConvertibleRoofState.CLOSED_SECURED || convertibleRoofState == ConvertibleRoofState.OPEN_SECURED || convertibleRoofState == ConvertibleRoofState.HARD_TOP_MOUNTED || convertibleRoofState == ConvertibleRoofState.INTERMEDIATE_POSITION || convertibleRoofState == ConvertibleRoofState.LOADING_POSITION || convertibleRoofState == ConvertibleRoofState.LOADING_POSITION_IMMEDIATE) {
                throw new IllegalArgumentException();
            }
            this.addProperty(this.convertibleRoofState.update(convertibleRoofState));
            this.addProperty(this.sunroofTiltState.update(sunroofTiltState));
            this.addProperty(this.sunroofState.update(sunroofState));
            if (this.dimming.getValue() == null && this.position.getValue() == null && this.convertibleRoofState.getValue() == null && this.sunroofTiltState.getValue() == null && this.sunroofState.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlRooftop(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.dimming.update(p);
                        }
                        case 2: {
                            return this.position.update(p);
                        }
                        case 3: {
                            return this.convertibleRoofState.update(p);
                        }
                        case 4: {
                            return this.sunroofTiltState.update(p);
                        }
                        case 5: {
                            return this.sunroofState.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.dimming.getValue() == null && this.position.getValue() == null && this.convertibleRoofState.getValue() == null && this.sunroofTiltState.getValue() == null && this.sunroofState.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetRooftopProperties
    extends GetCommand<State> {
        public GetRooftopProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)37, propertyIdentifiers);
        }

        public GetRooftopProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)37, new Bytes(propertyIdentifiers));
        }

        GetRooftopProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetRooftopState
    extends GetCommand<State> {
        public GetRooftopState() {
            super(State.class, 37);
        }

        public GetRooftopState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)37, propertyIdentifiers);
        }

        public GetRooftopState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)37, new Bytes(propertyIdentifiers));
        }

        GetRooftopState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetRooftopStateAvailability
    extends GetAvailabilityCommand {
        public GetRooftopStateAvailability() {
            super(37);
        }

        public GetRooftopStateAvailability(Bytes propertyIdentifiers) {
            super(37, propertyIdentifiers);
        }

        public GetRooftopStateAvailability(byte ... propertyIdentifiers) {
            super(37, new Bytes(propertyIdentifiers));
        }

        GetRooftopStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

