/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.PersonDetected;
import com.highmobility.autoapi.value.SeatLocation;
import com.highmobility.autoapi.value.SeatbeltState;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Seats {
    public static final int IDENTIFIER = 86;
    public static final byte PROPERTY_PERSONS_DETECTED = 2;
    public static final byte PROPERTY_SEATBELTS_STATE = 3;

    public static class State
    extends SetCommand {
        List<Property<PersonDetected>> personsDetected;
        List<Property<SeatbeltState>> seatbeltsState;

        public List<Property<PersonDetected>> getPersonsDetected() {
            return this.personsDetected;
        }

        public List<Property<SeatbeltState>> getSeatbeltsState() {
            return this.seatbeltsState;
        }

        @Nullable
        public Property<PersonDetected> getPersonDetection(SeatLocation location) {
            for (int i = 0; i < this.personsDetected.size(); ++i) {
                Property<PersonDetected> property = this.personsDetected.get(i);
                if (property.getValue() == null || property.getValue().getLocation() != location) continue;
                return property;
            }
            return null;
        }

        @Nullable
        public Property<SeatbeltState> getSeatBeltFastened(SeatLocation location) {
            for (int i = 0; i < this.seatbeltsState.size(); ++i) {
                Property<SeatbeltState> property = this.seatbeltsState.get(i);
                if (property.getValue() == null || property.getValue().getLocation() != location) continue;
                return property;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<PersonDetected>> personsDetectedBuilder = new ArrayList<Property<PersonDetected>>();
            ArrayList<Property<SeatbeltState>> seatbeltsStateBuilder = new ArrayList<Property<SeatbeltState>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            Property<PersonDetected> personDetected = new Property<PersonDetected>(PersonDetected.class, p);
                            personsDetectedBuilder.add(personDetected);
                            return personDetected;
                        }
                        case 3: {
                            Property<SeatbeltState> seatbeltState = new Property<SeatbeltState>(SeatbeltState.class, p);
                            seatbeltsStateBuilder.add(seatbeltState);
                            return seatbeltState;
                        }
                    }
                    return null;
                });
            }
            this.personsDetected = personsDetectedBuilder;
            this.seatbeltsState = seatbeltsStateBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(86);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setPersonsDetected(Property<PersonDetected>[] personsDetected) {
                for (int i = 0; i < personsDetected.length; ++i) {
                    this.addPersonDetected(personsDetected[i]);
                }
                return this;
            }

            public Builder addPersonDetected(Property<PersonDetected> personDetected) {
                personDetected.setIdentifier((byte)2);
                this.addProperty(personDetected);
                return this;
            }

            public Builder setSeatbeltsState(Property<SeatbeltState>[] seatbeltsState) {
                for (int i = 0; i < seatbeltsState.length; ++i) {
                    this.addSeatbeltState(seatbeltsState[i]);
                }
                return this;
            }

            public Builder addSeatbeltState(Property<SeatbeltState> seatbeltState) {
                seatbeltState.setIdentifier((byte)3);
                this.addProperty(seatbeltState);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)86, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)86, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 86);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)86, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)86, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(86);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(86, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(86, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

