/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.Detected;
import com.highmobility.autoapi.value.DriverCardPresent;
import com.highmobility.autoapi.value.DriverTimeState;
import com.highmobility.autoapi.value.DriverWorkingState;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Tachograph {
    public static final int IDENTIFIER = 100;
    public static final byte PROPERTY_DRIVERS_WORKING_STATES = 1;
    public static final byte PROPERTY_DRIVERS_TIME_STATES = 2;
    public static final byte PROPERTY_DRIVERS_CARDS_PRESENT = 3;
    public static final byte PROPERTY_VEHICLE_MOTION = 4;
    public static final byte PROPERTY_VEHICLE_OVERSPEED = 5;
    public static final byte PROPERTY_VEHICLE_DIRECTION = 6;
    public static final byte PROPERTY_VEHICLE_SPEED = 7;

    public static enum VehicleDirection implements ByteEnum
    {
        FORWARD(0),
        REVERSE(1);

        private final byte value;

        public static VehicleDirection fromByte(byte byteValue) throws CommandParseException {
            VehicleDirection[] values = VehicleDirection.values();
            for (int i = 0; i < values.length; ++i) {
                VehicleDirection state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(VehicleDirection.class.getSimpleName(), byteValue));
        }

        private VehicleDirection(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum VehicleOverspeed implements ByteEnum
    {
        NO_OVERSPEED(0),
        OVERSPEED(1);

        private final byte value;

        public static VehicleOverspeed fromByte(byte byteValue) throws CommandParseException {
            VehicleOverspeed[] values = VehicleOverspeed.values();
            for (int i = 0; i < values.length; ++i) {
                VehicleOverspeed state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(VehicleOverspeed.class.getSimpleName(), byteValue));
        }

        private VehicleOverspeed(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        List<Property<DriverWorkingState>> driversWorkingStates;
        List<Property<DriverTimeState>> driversTimeStates;
        List<Property<DriverCardPresent>> driversCardsPresent;
        Property<Detected> vehicleMotion = new Property<Detected>(Detected.class, 4);
        Property<VehicleOverspeed> vehicleOverspeed = new Property<VehicleOverspeed>(VehicleOverspeed.class, 5);
        Property<VehicleDirection> vehicleDirection = new Property<VehicleDirection>(VehicleDirection.class, 6);
        Property<Speed> vehicleSpeed = new Property<Speed>(Speed.class, 7);

        public List<Property<DriverWorkingState>> getDriversWorkingStates() {
            return this.driversWorkingStates;
        }

        public List<Property<DriverTimeState>> getDriversTimeStates() {
            return this.driversTimeStates;
        }

        public List<Property<DriverCardPresent>> getDriversCardsPresent() {
            return this.driversCardsPresent;
        }

        public Property<Detected> getVehicleMotion() {
            return this.vehicleMotion;
        }

        public Property<VehicleOverspeed> getVehicleOverspeed() {
            return this.vehicleOverspeed;
        }

        public Property<VehicleDirection> getVehicleDirection() {
            return this.vehicleDirection;
        }

        public Property<Speed> getVehicleSpeed() {
            return this.vehicleSpeed;
        }

        @Nullable
        public Property<DriverWorkingState> getDriverWorkingState(int driverNumber) {
            for (int i = 0; i < this.driversWorkingStates.size(); ++i) {
                Property<DriverWorkingState> state = this.driversWorkingStates.get(i);
                if (state.getValue() == null || state.getValue().getDriverNumber() != driverNumber) continue;
                return state;
            }
            return null;
        }

        @Nullable
        public Property<DriverTimeState> getDriverTimeState(int driverNumber) {
            for (int i = 0; i < this.driversTimeStates.size(); ++i) {
                Property<DriverTimeState> state = this.driversTimeStates.get(i);
                if (state.getValue() == null || state.getValue().getDriverNumber() != driverNumber) continue;
                return state;
            }
            return null;
        }

        @Nullable
        public Property<DriverCardPresent> getDriverCard(int driverNumber) {
            for (int i = 0; i < this.driversCardsPresent.size(); ++i) {
                Property<DriverCardPresent> state = this.driversCardsPresent.get(i);
                if (state.getValue() == null || state.getValue().getDriverNumber() != driverNumber) continue;
                return state;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<DriverWorkingState>> driversWorkingStatesBuilder = new ArrayList<Property<DriverWorkingState>>();
            ArrayList<Property<DriverTimeState>> driversTimeStatesBuilder = new ArrayList<Property<DriverTimeState>>();
            ArrayList<Property<DriverCardPresent>> driversCardsPresentBuilder = new ArrayList<Property<DriverCardPresent>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<DriverWorkingState> driverWorkingState = new Property<DriverWorkingState>(DriverWorkingState.class, p);
                            driversWorkingStatesBuilder.add(driverWorkingState);
                            return driverWorkingState;
                        }
                        case 2: {
                            Property<DriverTimeState> driversTimeState = new Property<DriverTimeState>(DriverTimeState.class, p);
                            driversTimeStatesBuilder.add(driversTimeState);
                            return driversTimeState;
                        }
                        case 3: {
                            Property<DriverCardPresent> driversCardPresent = new Property<DriverCardPresent>(DriverCardPresent.class, p);
                            driversCardsPresentBuilder.add(driversCardPresent);
                            return driversCardPresent;
                        }
                        case 4: {
                            return this.vehicleMotion.update(p);
                        }
                        case 5: {
                            return this.vehicleOverspeed.update(p);
                        }
                        case 6: {
                            return this.vehicleDirection.update(p);
                        }
                        case 7: {
                            return this.vehicleSpeed.update(p);
                        }
                    }
                    return null;
                });
            }
            this.driversWorkingStates = driversWorkingStatesBuilder;
            this.driversTimeStates = driversTimeStatesBuilder;
            this.driversCardsPresent = driversCardsPresentBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(100);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setDriversWorkingStates(Property<DriverWorkingState>[] driversWorkingStates) {
                for (int i = 0; i < driversWorkingStates.length; ++i) {
                    this.addDriverWorkingState(driversWorkingStates[i]);
                }
                return this;
            }

            public Builder addDriverWorkingState(Property<DriverWorkingState> driverWorkingState) {
                driverWorkingState.setIdentifier((byte)1);
                this.addProperty(driverWorkingState);
                return this;
            }

            public Builder setDriversTimeStates(Property<DriverTimeState>[] driversTimeStates) {
                for (int i = 0; i < driversTimeStates.length; ++i) {
                    this.addDriversTimeState(driversTimeStates[i]);
                }
                return this;
            }

            public Builder addDriversTimeState(Property<DriverTimeState> driversTimeState) {
                driversTimeState.setIdentifier((byte)2);
                this.addProperty(driversTimeState);
                return this;
            }

            public Builder setDriversCardsPresent(Property<DriverCardPresent>[] driversCardsPresent) {
                for (int i = 0; i < driversCardsPresent.length; ++i) {
                    this.addDriversCardPresent(driversCardsPresent[i]);
                }
                return this;
            }

            public Builder addDriversCardPresent(Property<DriverCardPresent> driversCardPresent) {
                driversCardPresent.setIdentifier((byte)3);
                this.addProperty(driversCardPresent);
                return this;
            }

            public Builder setVehicleMotion(Property<Detected> vehicleMotion) {
                Property<Detected> property = vehicleMotion.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleOverspeed(Property<VehicleOverspeed> vehicleOverspeed) {
                Property<VehicleOverspeed> property = vehicleOverspeed.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleDirection(Property<VehicleDirection> vehicleDirection) {
                Property<VehicleDirection> property = vehicleDirection.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleSpeed(Property<Speed> vehicleSpeed) {
                Property<Speed> property = vehicleSpeed.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)100, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)100, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 100);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)100, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)100, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(100);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(100, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(100, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

