/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.AddressComponent;
import com.highmobility.autoapi.value.Coordinates;
import com.highmobility.autoapi.value.EcoDrivingThreshold;
import com.highmobility.autoapi.value.measurement.FuelEfficiency;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.autoapi.value.measurement.Volume;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Trips {
    public static final int IDENTIFIER = 106;
    public static final byte PROPERTY_TYPE = 1;
    public static final byte PROPERTY_DRIVER_NAME = 2;
    public static final byte PROPERTY_DESCRIPTION = 3;
    public static final byte PROPERTY_START_TIME = 4;
    public static final byte PROPERTY_END_TIME = 5;
    public static final byte PROPERTY_START_ADDRESS = 6;
    public static final byte PROPERTY_END_ADDRESS = 7;
    public static final byte PROPERTY_START_COORDINATES = 8;
    public static final byte PROPERTY_END_COORDINATES = 9;
    public static final byte PROPERTY_START_ODOMETER = 10;
    public static final byte PROPERTY_END_ODOMETER = 11;
    public static final byte PROPERTY_AVERAGE_FUEL_CONSUMPTION = 12;
    public static final byte PROPERTY_DISTANCE = 13;
    public static final byte PROPERTY_START_ADDRESS_COMPONENTS = 14;
    public static final byte PROPERTY_END_ADDRESS_COMPONENTS = 15;
    public static final byte PROPERTY_EVENT = 16;
    public static final byte PROPERTY_ECO_LEVEL = 17;
    public static final byte PROPERTY_THRESHOLDS = 18;
    public static final byte PROPERTY_TOTAL_FUEL_CONSUMPTION = 19;
    public static final byte PROPERTY_TOTAL_IDLE_FUEL_CONSUMPTION = 20;
    public static final byte PROPERTY_MAXIMUM_SPEED = 21;
    public static final byte PROPERTY_ROAD_TYPE = 22;
    public static final byte PROPERTY_BRAKING_COUNT = 23;

    public static enum RoadType implements ByteEnum
    {
        PRIVATE_OR_GRAVEL(0),
        LOCAL(1),
        COUNTY(2),
        RURAL(3),
        FEDERAL_HIGHWAY(4),
        HIGHWAY(5),
        COUNTRY(6),
        NATIONAL(7);

        private final byte value;

        public static RoadType fromByte(byte byteValue) throws CommandParseException {
            RoadType[] values = RoadType.values();
            for (int i = 0; i < values.length; ++i) {
                RoadType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(RoadType.class.getSimpleName(), byteValue));
        }

        private RoadType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum EcoLevel implements ByteEnum
    {
        HIGH(0),
        MEDIUM(1);

        private final byte value;

        public static EcoLevel fromByte(byte byteValue) throws CommandParseException {
            EcoLevel[] values = EcoLevel.values();
            for (int i = 0; i < values.length; ++i) {
                EcoLevel state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(EcoLevel.class.getSimpleName(), byteValue));
        }

        private EcoLevel(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Event implements ByteEnum
    {
        HARSH_BRAKING(0),
        HARSH_ACCELERATION(1),
        SHARP_TURN(2),
        OVER_RPM(3),
        OVERSPEED(4),
        IDLING_ENGINE_ON(5),
        EMERGENCY_BRAKING(6);

        private final byte value;

        public static Event fromByte(byte byteValue) throws CommandParseException {
            Event[] values = Event.values();
            for (int i = 0; i < values.length; ++i) {
                Event state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Event.class.getSimpleName(), byteValue));
        }

        private Event(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Type implements ByteEnum
    {
        SINGLE(0),
        MULTI(1),
        ECO(2);

        private final byte value;

        public static Type fromByte(byte byteValue) throws CommandParseException {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                Type state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Type.class.getSimpleName(), byteValue));
        }

        private Type(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Type> type = new Property<Type>(Type.class, 1);
        Property<String> driverName = new Property<String>(String.class, 2);
        Property<String> description = new Property<String>(String.class, 3);
        Property<Calendar> startTime = new Property<Calendar>(Calendar.class, 4);
        Property<Calendar> endTime = new Property<Calendar>(Calendar.class, 5);
        Property<String> startAddress = new Property<String>(String.class, 6);
        Property<String> endAddress = new Property<String>(String.class, 7);
        Property<Coordinates> startCoordinates = new Property<Coordinates>(Coordinates.class, 8);
        Property<Coordinates> endCoordinates = new Property<Coordinates>(Coordinates.class, 9);
        Property<Length> startOdometer = new Property<Length>(Length.class, 10);
        Property<Length> endOdometer = new Property<Length>(Length.class, 11);
        Property<FuelEfficiency> averageFuelConsumption = new Property<FuelEfficiency>(FuelEfficiency.class, 12);
        Property<Length> distance = new Property<Length>(Length.class, 13);
        List<Property<AddressComponent>> startAddressComponents;
        List<Property<AddressComponent>> endAddressComponents;
        Property<Event> event = new Property<Event>(Event.class, 16);
        Property<EcoLevel> ecoLevel = new Property<EcoLevel>(EcoLevel.class, 17);
        List<Property<EcoDrivingThreshold>> thresholds;
        Property<Volume> totalFuelConsumption = new Property<Volume>(Volume.class, 19);
        Property<Volume> totalIdleFuelConsumption = new Property<Volume>(Volume.class, 20);
        Property<Speed> maximumSpeed = new Property<Speed>(Speed.class, 21);
        Property<RoadType> roadType = new Property<RoadType>(RoadType.class, 22);
        PropertyInteger brakingCount = new PropertyInteger(23, false);

        public Property<Type> getType() {
            return this.type;
        }

        public Property<String> getDriverName() {
            return this.driverName;
        }

        public Property<String> getDescription() {
            return this.description;
        }

        public Property<Calendar> getStartTime() {
            return this.startTime;
        }

        public Property<Calendar> getEndTime() {
            return this.endTime;
        }

        public Property<String> getStartAddress() {
            return this.startAddress;
        }

        public Property<String> getEndAddress() {
            return this.endAddress;
        }

        public Property<Coordinates> getStartCoordinates() {
            return this.startCoordinates;
        }

        public Property<Coordinates> getEndCoordinates() {
            return this.endCoordinates;
        }

        public Property<Length> getStartOdometer() {
            return this.startOdometer;
        }

        public Property<Length> getEndOdometer() {
            return this.endOdometer;
        }

        public Property<FuelEfficiency> getAverageFuelConsumption() {
            return this.averageFuelConsumption;
        }

        public Property<Length> getDistance() {
            return this.distance;
        }

        public List<Property<AddressComponent>> getStartAddressComponents() {
            return this.startAddressComponents;
        }

        public List<Property<AddressComponent>> getEndAddressComponents() {
            return this.endAddressComponents;
        }

        public Property<Event> getEvent() {
            return this.event;
        }

        public Property<EcoLevel> getEcoLevel() {
            return this.ecoLevel;
        }

        public List<Property<EcoDrivingThreshold>> getThresholds() {
            return this.thresholds;
        }

        public Property<Volume> getTotalFuelConsumption() {
            return this.totalFuelConsumption;
        }

        public Property<Volume> getTotalIdleFuelConsumption() {
            return this.totalIdleFuelConsumption;
        }

        public Property<Speed> getMaximumSpeed() {
            return this.maximumSpeed;
        }

        public Property<RoadType> getRoadType() {
            return this.roadType;
        }

        public PropertyInteger getBrakingCount() {
            return this.brakingCount;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<AddressComponent>> startAddressComponentsBuilder = new ArrayList<Property<AddressComponent>>();
            ArrayList<Property<AddressComponent>> endAddressComponentsBuilder = new ArrayList<Property<AddressComponent>>();
            ArrayList<Property<EcoDrivingThreshold>> thresholdsBuilder = new ArrayList<Property<EcoDrivingThreshold>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.type.update(p);
                        }
                        case 2: {
                            return this.driverName.update(p);
                        }
                        case 3: {
                            return this.description.update(p);
                        }
                        case 4: {
                            return this.startTime.update(p);
                        }
                        case 5: {
                            return this.endTime.update(p);
                        }
                        case 6: {
                            return this.startAddress.update(p);
                        }
                        case 7: {
                            return this.endAddress.update(p);
                        }
                        case 8: {
                            return this.startCoordinates.update(p);
                        }
                        case 9: {
                            return this.endCoordinates.update(p);
                        }
                        case 10: {
                            return this.startOdometer.update(p);
                        }
                        case 11: {
                            return this.endOdometer.update(p);
                        }
                        case 12: {
                            return this.averageFuelConsumption.update(p);
                        }
                        case 13: {
                            return this.distance.update(p);
                        }
                        case 14: {
                            Property<AddressComponent> startAddressComponent = new Property<AddressComponent>(AddressComponent.class, p);
                            startAddressComponentsBuilder.add(startAddressComponent);
                            return startAddressComponent;
                        }
                        case 15: {
                            Property<AddressComponent> endAddressComponent = new Property<AddressComponent>(AddressComponent.class, p);
                            endAddressComponentsBuilder.add(endAddressComponent);
                            return endAddressComponent;
                        }
                        case 16: {
                            return this.event.update(p);
                        }
                        case 17: {
                            return this.ecoLevel.update(p);
                        }
                        case 18: {
                            Property<EcoDrivingThreshold> threshold = new Property<EcoDrivingThreshold>(EcoDrivingThreshold.class, p);
                            thresholdsBuilder.add(threshold);
                            return threshold;
                        }
                        case 19: {
                            return this.totalFuelConsumption.update(p);
                        }
                        case 20: {
                            return this.totalIdleFuelConsumption.update(p);
                        }
                        case 21: {
                            return this.maximumSpeed.update(p);
                        }
                        case 22: {
                            return this.roadType.update(p);
                        }
                        case 23: {
                            return this.brakingCount.update(p);
                        }
                    }
                    return null;
                });
            }
            this.startAddressComponents = startAddressComponentsBuilder;
            this.endAddressComponents = endAddressComponentsBuilder;
            this.thresholds = thresholdsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(106);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setType(Property<Type> type) {
                Property<Type> property = type.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setDriverName(Property<String> driverName) {
                Property<String> property = driverName.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setDescription(Property<String> description) {
                Property<String> property = description.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setStartTime(Property<Calendar> startTime) {
                Property<Calendar> property = startTime.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setEndTime(Property<Calendar> endTime) {
                Property<Calendar> property = endTime.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setStartAddress(Property<String> startAddress) {
                Property<String> property = startAddress.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setEndAddress(Property<String> endAddress) {
                Property<String> property = endAddress.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setStartCoordinates(Property<Coordinates> startCoordinates) {
                Property<Coordinates> property = startCoordinates.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setEndCoordinates(Property<Coordinates> endCoordinates) {
                Property<Coordinates> property = endCoordinates.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setStartOdometer(Property<Length> startOdometer) {
                Property<Length> property = startOdometer.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setEndOdometer(Property<Length> endOdometer) {
                Property<Length> property = endOdometer.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setAverageFuelConsumption(Property<FuelEfficiency> averageFuelConsumption) {
                Property<FuelEfficiency> property = averageFuelConsumption.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setDistance(Property<Length> distance) {
                Property<Length> property = distance.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setStartAddressComponents(Property<AddressComponent>[] startAddressComponents) {
                for (int i = 0; i < startAddressComponents.length; ++i) {
                    this.addStartAddressComponent(startAddressComponents[i]);
                }
                return this;
            }

            public Builder addStartAddressComponent(Property<AddressComponent> startAddressComponent) {
                startAddressComponent.setIdentifier((byte)14);
                this.addProperty(startAddressComponent);
                return this;
            }

            public Builder setEndAddressComponents(Property<AddressComponent>[] endAddressComponents) {
                for (int i = 0; i < endAddressComponents.length; ++i) {
                    this.addEndAddressComponent(endAddressComponents[i]);
                }
                return this;
            }

            public Builder addEndAddressComponent(Property<AddressComponent> endAddressComponent) {
                endAddressComponent.setIdentifier((byte)15);
                this.addProperty(endAddressComponent);
                return this;
            }

            public Builder setEvent(Property<Event> event) {
                Property<Event> property = event.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setEcoLevel(Property<EcoLevel> ecoLevel) {
                Property<EcoLevel> property = ecoLevel.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            public Builder setThresholds(Property<EcoDrivingThreshold>[] thresholds) {
                for (int i = 0; i < thresholds.length; ++i) {
                    this.addThreshold(thresholds[i]);
                }
                return this;
            }

            public Builder addThreshold(Property<EcoDrivingThreshold> threshold) {
                threshold.setIdentifier((byte)18);
                this.addProperty(threshold);
                return this;
            }

            public Builder setTotalFuelConsumption(Property<Volume> totalFuelConsumption) {
                Property<Volume> property = totalFuelConsumption.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setTotalIdleFuelConsumption(Property<Volume> totalIdleFuelConsumption) {
                Property<Volume> property = totalIdleFuelConsumption.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setMaximumSpeed(Property<Speed> maximumSpeed) {
                Property<Speed> property = maximumSpeed.setIdentifier((byte)21);
                this.addProperty(property);
                return this;
            }

            public Builder setRoadType(Property<RoadType> roadType) {
                Property<RoadType> property = roadType.setIdentifier((byte)22);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakingCount(Property<Integer> brakingCount) {
                PropertyInteger property = new PropertyInteger(23, false, 2, brakingCount);
                this.addProperty(property);
                return this;
            }
        }
    }
}

