/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.EngineType;
import com.highmobility.autoapi.value.measurement.Mass;
import com.highmobility.autoapi.value.measurement.Power;
import com.highmobility.autoapi.value.measurement.Torque;
import com.highmobility.autoapi.value.measurement.Volume;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class VehicleInformation {
    public static final int IDENTIFIER = 20;
    public static final byte PROPERTY_POWERTRAIN = 2;
    public static final byte PROPERTY_MODEL_NAME = 3;
    public static final byte PROPERTY_NAME = 4;
    public static final byte PROPERTY_LICENSE_PLATE = 5;
    public static final byte PROPERTY_SALES_DESIGNATION = 6;
    public static final byte PROPERTY_MODEL_YEAR = 7;
    public static final byte PROPERTY_COLOUR_NAME = 8;
    public static final byte PROPERTY_POWER_IN_KW = 9;
    public static final byte PROPERTY_NUMBER_OF_DOORS = 10;
    public static final byte PROPERTY_NUMBER_OF_SEATS = 11;
    public static final byte PROPERTY_ENGINE_VOLUME = 12;
    public static final byte PROPERTY_ENGINE_MAX_TORQUE = 13;
    public static final byte PROPERTY_GEARBOX = 14;
    public static final byte PROPERTY_DISPLAY_UNIT = 15;
    public static final byte PROPERTY_DRIVER_SEAT_LOCATION = 16;
    public static final byte PROPERTY_EQUIPMENTS = 17;
    public static final byte PROPERTY_POWER = 19;
    public static final byte PROPERTY_LANGUAGE = 20;
    public static final byte PROPERTY_TIMEFORMAT = 21;
    public static final byte PROPERTY_DRIVE = 22;
    public static final byte PROPERTY_POWERTRAIN_SECONDARY = 23;
    public static final byte PROPERTY_FUEL_TANK_CAPACITY = 24;
    public static final byte PROPERTY_BUILD_DATE = 25;
    public static final byte PROPERTY_COUNTRY_CODE = 26;
    public static final byte PROPERTY_MODEL_KEY = 27;
    public static final byte PROPERTY_DATA_QUALITY = 28;
    public static final byte PROPERTY_EXTRA_EQUIPMENT_CODES = 29;
    public static final byte PROPERTY_SERIES = 30;
    public static final byte PROPERTY_LAST_DATA_TRANSFER_DATE = 31;
    public static final byte PROPERTY_TIME_ZONE = 32;
    public static final byte PROPERTY_VEHICLE_MASS = 33;

    public static enum TimeZone implements ByteEnum
    {
        WINTERTIME(0),
        SUMMERTIME(1),
        UTC(2),
        MANUAL(3);

        private final byte value;

        public static TimeZone fromByte(byte byteValue) throws CommandParseException {
            TimeZone[] values = TimeZone.values();
            for (int i = 0; i < values.length; ++i) {
                TimeZone state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(TimeZone.class.getSimpleName(), byteValue));
        }

        private TimeZone(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum DataQuality implements ByteEnum
    {
        NO_DATA(0),
        UP_TO_DATE(1),
        ALMOST_UP_TO_DATE(2),
        OUT_OF_DATE(3);

        private final byte value;

        public static DataQuality fromByte(byte byteValue) throws CommandParseException {
            DataQuality[] values = DataQuality.values();
            for (int i = 0; i < values.length; ++i) {
                DataQuality state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DataQuality.class.getSimpleName(), byteValue));
        }

        private DataQuality(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Drive implements ByteEnum
    {
        FWD(0),
        RWD(1),
        FOUR_WD(2),
        AWD(3);

        private final byte value;

        public static Drive fromByte(byte byteValue) throws CommandParseException {
            Drive[] values = Drive.values();
            for (int i = 0; i < values.length; ++i) {
                Drive state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Drive.class.getSimpleName(), byteValue));
        }

        private Drive(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Timeformat implements ByteEnum
    {
        TWELVE_H(0),
        TWENTY_FOUR_H(1);

        private final byte value;

        public static Timeformat fromByte(byte byteValue) throws CommandParseException {
            Timeformat[] values = Timeformat.values();
            for (int i = 0; i < values.length; ++i) {
                Timeformat state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Timeformat.class.getSimpleName(), byteValue));
        }

        private Timeformat(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum DriverSeatLocation implements ByteEnum
    {
        LEFT(0),
        RIGHT(1),
        CENTER(2);

        private final byte value;

        public static DriverSeatLocation fromByte(byte byteValue) throws CommandParseException {
            DriverSeatLocation[] values = DriverSeatLocation.values();
            for (int i = 0; i < values.length; ++i) {
                DriverSeatLocation state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DriverSeatLocation.class.getSimpleName(), byteValue));
        }

        private DriverSeatLocation(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum DisplayUnit implements ByteEnum
    {
        KM(0),
        MILES(1);

        private final byte value;

        public static DisplayUnit fromByte(byte byteValue) throws CommandParseException {
            DisplayUnit[] values = DisplayUnit.values();
            for (int i = 0; i < values.length; ++i) {
                DisplayUnit state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DisplayUnit.class.getSimpleName(), byteValue));
        }

        private DisplayUnit(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Gearbox implements ByteEnum
    {
        MANUAL(0),
        AUTOMATIC(1),
        SEMI_AUTOMATIC(2);

        private final byte value;

        public static Gearbox fromByte(byte byteValue) throws CommandParseException {
            Gearbox[] values = Gearbox.values();
            for (int i = 0; i < values.length; ++i) {
                Gearbox state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Gearbox.class.getSimpleName(), byteValue));
        }

        private Gearbox(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<EngineType> powertrain = new Property<EngineType>(EngineType.class, 2);
        Property<String> modelName = new Property<String>(String.class, 3);
        Property<String> name = new Property<String>(String.class, 4);
        Property<String> licensePlate = new Property<String>(String.class, 5);
        Property<String> salesDesignation = new Property<String>(String.class, 6);
        PropertyInteger modelYear = new PropertyInteger(7, false);
        Property<String> colourName = new Property<String>(String.class, 8);
        Property<Power> powerInKW = new Property<Power>(Power.class, 9);
        PropertyInteger numberOfDoors = new PropertyInteger(10, false);
        PropertyInteger numberOfSeats = new PropertyInteger(11, false);
        Property<Volume> engineVolume = new Property<Volume>(Volume.class, 12);
        Property<Torque> engineMaxTorque = new Property<Torque>(Torque.class, 13);
        Property<Gearbox> gearbox = new Property<Gearbox>(Gearbox.class, 14);
        Property<DisplayUnit> displayUnit = new Property<DisplayUnit>(DisplayUnit.class, 15);
        Property<DriverSeatLocation> driverSeatLocation = new Property<DriverSeatLocation>(DriverSeatLocation.class, 16);
        List<Property<String>> equipments;
        Property<Power> power = new Property<Power>(Power.class, 19);
        Property<String> language = new Property<String>(String.class, 20);
        Property<Timeformat> timeformat = new Property<Timeformat>(Timeformat.class, 21);
        Property<Drive> drive = new Property<Drive>(Drive.class, 22);
        Property<EngineType> powertrainSecondary = new Property<EngineType>(EngineType.class, 23);
        Property<Volume> fuelTankCapacity = new Property<Volume>(Volume.class, 24);
        Property<Calendar> buildDate = new Property<Calendar>(Calendar.class, 25);
        Property<String> countryCode = new Property<String>(String.class, 26);
        Property<String> modelKey = new Property<String>(String.class, 27);
        Property<DataQuality> dataQuality = new Property<DataQuality>(DataQuality.class, 28);
        List<Property<String>> extraEquipmentCodes;
        Property<String> series = new Property<String>(String.class, 30);
        Property<Calendar> lastDataTransferDate = new Property<Calendar>(Calendar.class, 31);
        Property<TimeZone> timeZone = new Property<TimeZone>(TimeZone.class, 32);
        Property<Mass> vehicleMass = new Property<Mass>(Mass.class, 33);

        public Property<EngineType> getPowertrain() {
            return this.powertrain;
        }

        public Property<String> getModelName() {
            return this.modelName;
        }

        public Property<String> getName() {
            return this.name;
        }

        public Property<String> getLicensePlate() {
            return this.licensePlate;
        }

        public Property<String> getSalesDesignation() {
            return this.salesDesignation;
        }

        public PropertyInteger getModelYear() {
            return this.modelYear;
        }

        public Property<String> getColourName() {
            return this.colourName;
        }

        @Deprecated
        public Property<Power> getPowerInKW() {
            return this.powerInKW;
        }

        public PropertyInteger getNumberOfDoors() {
            return this.numberOfDoors;
        }

        public PropertyInteger getNumberOfSeats() {
            return this.numberOfSeats;
        }

        public Property<Volume> getEngineVolume() {
            return this.engineVolume;
        }

        public Property<Torque> getEngineMaxTorque() {
            return this.engineMaxTorque;
        }

        public Property<Gearbox> getGearbox() {
            return this.gearbox;
        }

        public Property<DisplayUnit> getDisplayUnit() {
            return this.displayUnit;
        }

        public Property<DriverSeatLocation> getDriverSeatLocation() {
            return this.driverSeatLocation;
        }

        public List<Property<String>> getEquipments() {
            return this.equipments;
        }

        public Property<Power> getPower() {
            return this.power;
        }

        public Property<String> getLanguage() {
            return this.language;
        }

        public Property<Timeformat> getTimeformat() {
            return this.timeformat;
        }

        public Property<Drive> getDrive() {
            return this.drive;
        }

        public Property<EngineType> getPowertrainSecondary() {
            return this.powertrainSecondary;
        }

        public Property<Volume> getFuelTankCapacity() {
            return this.fuelTankCapacity;
        }

        public Property<Calendar> getBuildDate() {
            return this.buildDate;
        }

        public Property<String> getCountryCode() {
            return this.countryCode;
        }

        public Property<String> getModelKey() {
            return this.modelKey;
        }

        public Property<DataQuality> getDataQuality() {
            return this.dataQuality;
        }

        public List<Property<String>> getExtraEquipmentCodes() {
            return this.extraEquipmentCodes;
        }

        public Property<String> getSeries() {
            return this.series;
        }

        public Property<Calendar> getLastDataTransferDate() {
            return this.lastDataTransferDate;
        }

        public Property<TimeZone> getTimeZone() {
            return this.timeZone;
        }

        public Property<Mass> getVehicleMass() {
            return this.vehicleMass;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<String>> equipmentsBuilder = new ArrayList<Property<String>>();
            ArrayList<Property<String>> extraEquipmentCodesBuilder = new ArrayList<Property<String>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.powertrain.update(p);
                        }
                        case 3: {
                            return this.modelName.update(p);
                        }
                        case 4: {
                            return this.name.update(p);
                        }
                        case 5: {
                            return this.licensePlate.update(p);
                        }
                        case 6: {
                            return this.salesDesignation.update(p);
                        }
                        case 7: {
                            return this.modelYear.update(p);
                        }
                        case 8: {
                            return this.colourName.update(p);
                        }
                        case 9: {
                            return this.powerInKW.update(p);
                        }
                        case 10: {
                            return this.numberOfDoors.update(p);
                        }
                        case 11: {
                            return this.numberOfSeats.update(p);
                        }
                        case 12: {
                            return this.engineVolume.update(p);
                        }
                        case 13: {
                            return this.engineMaxTorque.update(p);
                        }
                        case 14: {
                            return this.gearbox.update(p);
                        }
                        case 15: {
                            return this.displayUnit.update(p);
                        }
                        case 16: {
                            return this.driverSeatLocation.update(p);
                        }
                        case 17: {
                            Property<String> equipment = new Property<String>(String.class, p);
                            equipmentsBuilder.add(equipment);
                            return equipment;
                        }
                        case 19: {
                            return this.power.update(p);
                        }
                        case 20: {
                            return this.language.update(p);
                        }
                        case 21: {
                            return this.timeformat.update(p);
                        }
                        case 22: {
                            return this.drive.update(p);
                        }
                        case 23: {
                            return this.powertrainSecondary.update(p);
                        }
                        case 24: {
                            return this.fuelTankCapacity.update(p);
                        }
                        case 25: {
                            return this.buildDate.update(p);
                        }
                        case 26: {
                            return this.countryCode.update(p);
                        }
                        case 27: {
                            return this.modelKey.update(p);
                        }
                        case 28: {
                            return this.dataQuality.update(p);
                        }
                        case 29: {
                            Property<String> extraEquipmentCode = new Property<String>(String.class, p);
                            extraEquipmentCodesBuilder.add(extraEquipmentCode);
                            return extraEquipmentCode;
                        }
                        case 30: {
                            return this.series.update(p);
                        }
                        case 31: {
                            return this.lastDataTransferDate.update(p);
                        }
                        case 32: {
                            return this.timeZone.update(p);
                        }
                        case 33: {
                            return this.vehicleMass.update(p);
                        }
                    }
                    return null;
                });
            }
            this.equipments = equipmentsBuilder;
            this.extraEquipmentCodes = extraEquipmentCodesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(20);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setPowertrain(Property<EngineType> powertrain) {
                Property<EngineType> property = powertrain.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setModelName(Property<String> modelName) {
                Property<String> property = modelName.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setName(Property<String> name) {
                Property<String> property = name.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setLicensePlate(Property<String> licensePlate) {
                Property<String> property = licensePlate.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setSalesDesignation(Property<String> salesDesignation) {
                Property<String> property = salesDesignation.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setModelYear(Property<Integer> modelYear) {
                PropertyInteger property = new PropertyInteger(7, false, 2, modelYear);
                this.addProperty(property);
                return this;
            }

            public Builder setColourName(Property<String> colourName) {
                Property<String> property = colourName.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setPowerInKW(Property<Power> powerInKW) {
                Property<Power> property = powerInKW.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setNumberOfDoors(Property<Integer> numberOfDoors) {
                PropertyInteger property = new PropertyInteger(10, false, 1, numberOfDoors);
                this.addProperty(property);
                return this;
            }

            public Builder setNumberOfSeats(Property<Integer> numberOfSeats) {
                PropertyInteger property = new PropertyInteger(11, false, 1, numberOfSeats);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineVolume(Property<Volume> engineVolume) {
                Property<Volume> property = engineVolume.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineMaxTorque(Property<Torque> engineMaxTorque) {
                Property<Torque> property = engineMaxTorque.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setGearbox(Property<Gearbox> gearbox) {
                Property<Gearbox> property = gearbox.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setDisplayUnit(Property<DisplayUnit> displayUnit) {
                Property<DisplayUnit> property = displayUnit.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setDriverSeatLocation(Property<DriverSeatLocation> driverSeatLocation) {
                Property<DriverSeatLocation> property = driverSeatLocation.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setEquipments(Property<String>[] equipments) {
                for (int i = 0; i < equipments.length; ++i) {
                    this.addEquipment(equipments[i]);
                }
                return this;
            }

            public Builder addEquipment(Property<String> equipment) {
                equipment.setIdentifier((byte)17);
                this.addProperty(equipment);
                return this;
            }

            public Builder setPower(Property<Power> power) {
                Property<Power> property = power.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setLanguage(Property<String> language) {
                Property<String> property = language.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeformat(Property<Timeformat> timeformat) {
                Property<Timeformat> property = timeformat.setIdentifier((byte)21);
                this.addProperty(property);
                return this;
            }

            public Builder setDrive(Property<Drive> drive) {
                Property<Drive> property = drive.setIdentifier((byte)22);
                this.addProperty(property);
                return this;
            }

            public Builder setPowertrainSecondary(Property<EngineType> powertrainSecondary) {
                Property<EngineType> property = powertrainSecondary.setIdentifier((byte)23);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelTankCapacity(Property<Volume> fuelTankCapacity) {
                Property<Volume> property = fuelTankCapacity.setIdentifier((byte)24);
                this.addProperty(property);
                return this;
            }

            public Builder setBuildDate(Property<Calendar> buildDate) {
                Property<Calendar> property = buildDate.setIdentifier((byte)25);
                this.addProperty(property);
                return this;
            }

            public Builder setCountryCode(Property<String> countryCode) {
                Property<String> property = countryCode.setIdentifier((byte)26);
                this.addProperty(property);
                return this;
            }

            public Builder setModelKey(Property<String> modelKey) {
                Property<String> property = modelKey.setIdentifier((byte)27);
                this.addProperty(property);
                return this;
            }

            public Builder setDataQuality(Property<DataQuality> dataQuality) {
                Property<DataQuality> property = dataQuality.setIdentifier((byte)28);
                this.addProperty(property);
                return this;
            }

            public Builder setExtraEquipmentCodes(Property<String>[] extraEquipmentCodes) {
                for (int i = 0; i < extraEquipmentCodes.length; ++i) {
                    this.addExtraEquipmentCode(extraEquipmentCodes[i]);
                }
                return this;
            }

            public Builder addExtraEquipmentCode(Property<String> extraEquipmentCode) {
                extraEquipmentCode.setIdentifier((byte)29);
                this.addProperty(extraEquipmentCode);
                return this;
            }

            public Builder setSeries(Property<String> series) {
                Property<String> property = series.setIdentifier((byte)30);
                this.addProperty(property);
                return this;
            }

            public Builder setLastDataTransferDate(Property<Calendar> lastDataTransferDate) {
                Property<Calendar> property = lastDataTransferDate.setIdentifier((byte)31);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeZone(Property<TimeZone> timeZone) {
                Property<TimeZone> property = timeZone.setIdentifier((byte)32);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleMass(Property<Mass> vehicleMass) {
                Property<Mass> property = vehicleMass.setIdentifier((byte)33);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetVehicleInformationProperties
    extends GetCommand<State> {
        public GetVehicleInformationProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)20, propertyIdentifiers);
        }

        public GetVehicleInformationProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)20, new Bytes(propertyIdentifiers));
        }

        GetVehicleInformationProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetVehicleInformation
    extends GetCommand<State> {
        public GetVehicleInformation() {
            super(State.class, 20);
        }

        public GetVehicleInformation(Bytes propertyIdentifiers) {
            super(State.class, (Integer)20, propertyIdentifiers);
        }

        public GetVehicleInformation(byte ... propertyIdentifiers) {
            super(State.class, (Integer)20, new Bytes(propertyIdentifiers));
        }

        GetVehicleInformation(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }
}

