/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class VehicleStatus {
    public static final int IDENTIFIER = 17;
    public static final byte PROPERTY_STATES = -103;

    public static class State
    extends SetCommand {
        List<Property<Command>> states;

        public List<Property<Command>> getStates() {
            return this.states;
        }

        @Nullable
        public Property<Command> getState(Integer identifier) {
            if (this.states == null) {
                return null;
            }
            for (int i = 0; i < this.states.size(); ++i) {
                Property<Command> command = this.states.get(i);
                if (command.getValue() == null || command.getValue().getIdentifier() != identifier.intValue()) continue;
                return command;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Command>> statesBuilder = new ArrayList<Property<Command>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case -103: {
                            Property<Command> state = new Property<Command>(Command.class, p);
                            statesBuilder.add(state);
                            return state;
                        }
                    }
                    return null;
                });
            }
            this.states = statesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(17);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStates(Property<Command>[] states) {
                for (int i = 0; i < states.length; ++i) {
                    this.addState(states[i]);
                }
                return this;
            }

            public Builder addState(Property<Command> state) {
                state.setIdentifier((byte)-103);
                this.addProperty(state);
                return this;
            }
        }
    }

    public static class GetVehicleStatus
    extends GetCommand<State> {
        public GetVehicleStatus() {
            super(State.class, 17);
        }

        GetVehicleStatus(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }
}

