/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.Duration;
import javax.annotation.Nullable;

public class VideoHandover {
    public static final int IDENTIFIER = 67;
    public static final byte PROPERTY_URL = 1;
    public static final byte PROPERTY_STARTING_SECOND = 2;
    public static final byte PROPERTY_SCREEN = 3;
    public static final byte PROPERTY_STARTING_TIME = 4;

    public static enum Screen implements ByteEnum
    {
        FRONT(0),
        REAR(1);

        private final byte value;

        public static Screen fromByte(byte byteValue) throws CommandParseException {
            Screen[] values = Screen.values();
            for (int i = 0; i < values.length; ++i) {
                Screen state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Screen.class.getSimpleName(), byteValue));
        }

        private Screen(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class VideoHandoverCommand
    extends SetCommand {
        Property<String> url = new Property<String>(String.class, 1);
        Property<Screen> screen = new Property<Screen>(Screen.class, 3);
        Property<Duration> startingTime = new Property<Duration>(Duration.class, 4);

        public Property<String> getUrl() {
            return this.url;
        }

        public Property<Screen> getScreen() {
            return this.screen;
        }

        public Property<Duration> getStartingTime() {
            return this.startingTime;
        }

        public VideoHandoverCommand(String url, @Nullable Screen screen, @Nullable Duration startingTime) {
            super(67);
            this.addProperty(this.url.update(url));
            this.addProperty(this.screen.update(screen));
            this.addProperty(this.startingTime.update(startingTime));
            this.createBytes();
        }

        VideoHandoverCommand(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.url.update(p);
                        }
                        case 3: {
                            return this.screen.update(p);
                        }
                        case 4: {
                            return this.startingTime.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.url.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

