/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;

public class WeatherConditions {
    public static final int IDENTIFIER = 85;
    public static final byte PROPERTY_RAIN_INTENSITY = 1;

    public static class State
    extends SetCommand {
        Property<Double> rainIntensity = new Property<Double>(Double.class, 1);

        public Property<Double> getRainIntensity() {
            return this.rainIntensity;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.rainIntensity.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(85);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setRainIntensity(Property<Double> rainIntensity) {
                Property<Double> property = rainIntensity.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class GetWeatherConditions
    extends GetCommand<State> {
        public GetWeatherConditions() {
            super(State.class, 85);
        }

        GetWeatherConditions(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetWeatherConditionsAvailability
    extends GetAvailabilityCommand {
        public GetWeatherConditionsAvailability() {
            super(85);
        }

        GetWeatherConditionsAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

