/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ConnectionState;
import com.highmobility.autoapi.value.EnabledState;
import com.highmobility.autoapi.value.NetworkSecurity;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class WiFi {
    public static final int IDENTIFIER = 89;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_NETWORK_CONNECTED = 2;
    public static final byte PROPERTY_NETWORK_SSID = 3;
    public static final byte PROPERTY_NETWORK_SECURITY = 4;
    public static final byte PROPERTY_PASSWORD = 5;

    public static class State
    extends SetCommand {
        Property<EnabledState> status = new Property<EnabledState>(EnabledState.class, 1);
        Property<ConnectionState> networkConnected = new Property<ConnectionState>(ConnectionState.class, 2);
        Property<String> networkSSID = new Property<String>(String.class, 3);
        Property<NetworkSecurity> networkSecurity = new Property<NetworkSecurity>(NetworkSecurity.class, 4);

        public Property<EnabledState> getStatus() {
            return this.status;
        }

        public Property<ConnectionState> getNetworkConnected() {
            return this.networkConnected;
        }

        public Property<String> getNetworkSSID() {
            return this.networkSSID;
        }

        public Property<NetworkSecurity> getNetworkSecurity() {
            return this.networkSecurity;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.networkConnected.update(p);
                        }
                        case 3: {
                            return this.networkSSID.update(p);
                        }
                        case 4: {
                            return this.networkSecurity.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(89);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<EnabledState> status) {
                Property<EnabledState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setNetworkConnected(Property<ConnectionState> networkConnected) {
                Property<ConnectionState> property = networkConnected.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setNetworkSSID(Property<String> networkSSID) {
                Property<String> property = networkSSID.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setNetworkSecurity(Property<NetworkSecurity> networkSecurity) {
                Property<NetworkSecurity> property = networkSecurity.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class EnableDisableWiFi
    extends SetCommand {
        Property<EnabledState> status = new Property<EnabledState>(EnabledState.class, 1);

        public Property<EnabledState> getStatus() {
            return this.status;
        }

        public EnableDisableWiFi(EnabledState status) {
            super(89);
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        EnableDisableWiFi(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class ForgetNetwork
    extends SetCommand {
        Property<String> networkSSID = new Property<String>(String.class, 3);

        public Property<String> getNetworkSSID() {
            return this.networkSSID;
        }

        public ForgetNetwork(String networkSSID) {
            super(89);
            this.addProperty(this.networkSSID.update(networkSSID));
            this.createBytes();
        }

        ForgetNetwork(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 3) {
                        return this.networkSSID.update(p);
                    }
                    return null;
                });
            }
            if (this.networkSSID.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class ConnectToNetwork
    extends SetCommand {
        Property<String> networkSSID = new Property<String>(String.class, 3);
        Property<NetworkSecurity> networkSecurity = new Property<NetworkSecurity>(NetworkSecurity.class, 4);
        Property<String> password = new Property<String>(String.class, 5);

        public Property<String> getNetworkSSID() {
            return this.networkSSID;
        }

        public Property<NetworkSecurity> getNetworkSecurity() {
            return this.networkSecurity;
        }

        public Property<String> getPassword() {
            return this.password;
        }

        public ConnectToNetwork(String networkSSID, NetworkSecurity networkSecurity, @Nullable String password) {
            super(89);
            this.addProperty(this.networkSSID.update(networkSSID));
            this.addProperty(this.networkSecurity.update(networkSecurity));
            this.addProperty(this.password.update(password));
            this.createBytes();
        }

        ConnectToNetwork(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 3: {
                            return this.networkSSID.update(p);
                        }
                        case 4: {
                            return this.networkSecurity.update(p);
                        }
                        case 5: {
                            return this.password.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.networkSSID.getValue() == null || this.networkSecurity.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)89, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)89, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 89);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)89, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)89, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(89);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(89, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(89, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

