/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.WindowLocation;
import com.highmobility.autoapi.value.WindowOpenPercentage;
import com.highmobility.autoapi.value.WindowPosition;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Windows {
    public static final int IDENTIFIER = 69;
    public static final byte PROPERTY_OPEN_PERCENTAGES = 2;
    public static final byte PROPERTY_POSITIONS = 3;

    public static class State
    extends SetCommand {
        List<Property<WindowOpenPercentage>> openPercentages;
        List<Property<WindowPosition>> positions;

        public List<Property<WindowOpenPercentage>> getOpenPercentages() {
            return this.openPercentages;
        }

        public List<Property<WindowPosition>> getPositions() {
            return this.positions;
        }

        @Nullable
        public Property<WindowPosition> getPosition(WindowLocation location) {
            for (Property<WindowPosition> windowPosition : this.positions) {
                if (windowPosition.getValue() == null || windowPosition.getValue().getLocation() != location) continue;
                return windowPosition;
            }
            return null;
        }

        @Nullable
        public Property<WindowOpenPercentage> getOpenPercentage(WindowLocation location) {
            for (Property<WindowOpenPercentage> windowOpenPercentage : this.openPercentages) {
                if (windowOpenPercentage.getValue() == null || windowOpenPercentage.getValue().getLocation() != location) continue;
                return windowOpenPercentage;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<WindowOpenPercentage>> openPercentagesBuilder = new ArrayList<Property<WindowOpenPercentage>>();
            ArrayList<Property<WindowPosition>> positionsBuilder = new ArrayList<Property<WindowPosition>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            Property<WindowOpenPercentage> openPercentage = new Property<WindowOpenPercentage>(WindowOpenPercentage.class, p);
                            openPercentagesBuilder.add(openPercentage);
                            return openPercentage;
                        }
                        case 3: {
                            Property<WindowPosition> position = new Property<WindowPosition>(WindowPosition.class, p);
                            positionsBuilder.add(position);
                            return position;
                        }
                    }
                    return null;
                });
            }
            this.openPercentages = openPercentagesBuilder;
            this.positions = positionsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(69);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setOpenPercentages(Property<WindowOpenPercentage>[] openPercentages) {
                for (int i = 0; i < openPercentages.length; ++i) {
                    this.addOpenPercentage(openPercentages[i]);
                }
                return this;
            }

            public Builder addOpenPercentage(Property<WindowOpenPercentage> openPercentage) {
                openPercentage.setIdentifier((byte)2);
                this.addProperty(openPercentage);
                return this;
            }

            public Builder setPositions(Property<WindowPosition>[] positions) {
                for (int i = 0; i < positions.length; ++i) {
                    this.addPosition(positions[i]);
                }
                return this;
            }

            public Builder addPosition(Property<WindowPosition> position) {
                position.setIdentifier((byte)3);
                this.addProperty(position);
                return this;
            }
        }
    }

    public static class ControlWindows
    extends SetCommand {
        List<Property<WindowOpenPercentage>> openPercentages;
        List<Property<WindowPosition>> positions;

        public List<Property<WindowOpenPercentage>> getOpenPercentages() {
            return this.openPercentages;
        }

        public List<Property<WindowPosition>> getPositions() {
            return this.positions;
        }

        public ControlWindows(@Nullable List<WindowOpenPercentage> openPercentages, @Nullable List<WindowPosition> positions) {
            super(69);
            ArrayList<Property<WindowOpenPercentage>> openPercentagesBuilder = new ArrayList<Property<WindowOpenPercentage>>();
            if (openPercentages != null) {
                for (WindowOpenPercentage openPercentage : openPercentages) {
                    Property<WindowOpenPercentage> prop = new Property<WindowOpenPercentage>(2, openPercentage);
                    openPercentagesBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.openPercentages = openPercentagesBuilder;
            ArrayList<Property<WindowPosition>> positionsBuilder = new ArrayList<Property<WindowPosition>>();
            if (positions != null) {
                for (WindowPosition position : positions) {
                    Property<WindowPosition> prop = new Property<WindowPosition>(3, position);
                    positionsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.positions = positionsBuilder;
            if (this.openPercentages.size() == 0 && this.positions.size() == 0) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlWindows(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<WindowOpenPercentage>> openPercentagesBuilder = new ArrayList<Property<WindowOpenPercentage>>();
            ArrayList<Property<WindowPosition>> positionsBuilder = new ArrayList<Property<WindowPosition>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            Property<WindowOpenPercentage> openPercentage = new Property<WindowOpenPercentage>(WindowOpenPercentage.class, p);
                            openPercentagesBuilder.add(openPercentage);
                            return openPercentage;
                        }
                        case 3: {
                            Property<WindowPosition> position = new Property<WindowPosition>(WindowPosition.class, p);
                            positionsBuilder.add(position);
                            return position;
                        }
                    }
                    return null;
                });
            }
            this.openPercentages = openPercentagesBuilder;
            this.positions = positionsBuilder;
            if (this.openPercentages.size() == 0 && this.positions.size() == 0) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetWindowsProperties
    extends GetCommand<State> {
        public GetWindowsProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)69, propertyIdentifiers);
        }

        public GetWindowsProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)69, new Bytes(propertyIdentifiers));
        }

        GetWindowsProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetWindows
    extends GetCommand<State> {
        public GetWindows() {
            super(State.class, 69);
        }

        public GetWindows(Bytes propertyIdentifiers) {
            super(State.class, (Integer)69, propertyIdentifiers);
        }

        public GetWindows(byte ... propertyIdentifiers) {
            super(State.class, (Integer)69, new Bytes(propertyIdentifiers));
        }

        GetWindows(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetWindowsAvailability
    extends GetAvailabilityCommand {
        public GetWindowsAvailability() {
            super(69);
        }

        public GetWindowsAvailability(Bytes propertyIdentifiers) {
            super(69, propertyIdentifiers);
        }

        public GetWindowsAvailability(byte ... propertyIdentifiers) {
            super(69, new Bytes(propertyIdentifiers));
        }

        GetWindowsAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

