/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.property;

import com.highmobility.autoapi.exception.ParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.value.Bytes;

public class PropertyComponent
extends Bytes {
    byte identifier;
    Bytes valueBytes;

    public Bytes getValueBytes() {
        return this.valueBytes;
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    PropertyComponent(Bytes componentBytes) {
        if (componentBytes.getLength() < 3) {
            throw new ParseException();
        }
        this.bytes = componentBytes.getByteArray();
        this.identifier = this.bytes[0];
        this.valueBytes = componentBytes.getRange(3, this.getLength());
    }

    PropertyComponent(byte identifier, Bytes valueBytes) {
        this(identifier, valueBytes.getLength());
        this.valueBytes = valueBytes;
        this.set(3, valueBytes);
    }

    PropertyComponent(byte identifier, int valueSize) {
        this.identifier = identifier;
        this.bytes = new byte[3 + valueSize];
        this.bytes[0] = identifier;
        this.set(1, Property.intToBytes(valueSize, 2));
        this.valueBytes = new Bytes(valueSize);
    }
}

