/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.property;

import com.highmobility.autoapi.AutoApiLogger;
import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyComponent;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import javax.annotation.Nullable;

public class PropertyComponentValue<V>
extends PropertyComponent {
    static final byte IDENTIFIER = 1;
    Class<V> valueClass = null;
    @Nullable
    protected V value;
    public static final int CALENDAR_SIZE = 8;
    public static final String CHARSET = "UTF-8";

    @Nullable
    public V getValue() {
        return this.value;
    }

    @Nullable
    public Byte getValueByte() {
        return this.valueBytes != null && this.valueBytes.getLength() > 0 ? this.valueBytes.get(0) : null;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    PropertyComponentValue(byte identifier, int valueSize) {
        super(identifier, valueSize);
    }

    PropertyComponentValue(Bytes value, Class<V> valueClass) throws CommandParseException {
        super(value);
        if (valueClass != null) {
            this.setClass(valueClass);
        }
    }

    PropertyComponentValue(@Nullable V value) {
        super((byte)1, PropertyComponentValue.getBytes(value));
        this.valueClass = value.getClass();
        this.value = value;
    }

    public void setClass(Class<V> valueClass) throws CommandParseException {
        if (PropertyValueObject.class.isAssignableFrom(valueClass)) {
            this.value = this.getValueWithReflection(valueClass, this.valueBytes);
        } else if (ByteEnum.class.isAssignableFrom(valueClass)) {
            this.value = this.getValueWithReflection(valueClass, this.valueBytes);
        } else if (Boolean.class.isAssignableFrom(valueClass)) {
            this.value = Property.getBool(this.valueBytes.get(0));
        } else if (Float.class.isAssignableFrom(valueClass)) {
            this.value = Float.valueOf(Property.getFloat(this.valueBytes));
        } else if (Double.class.isAssignableFrom(valueClass)) {
            this.value = Property.getDouble(this.valueBytes);
        } else if (Calendar.class.isAssignableFrom(valueClass)) {
            this.value = Property.getCalendar(this.valueBytes);
        } else if (String.class.isAssignableFrom(valueClass)) {
            this.value = Property.getString(this.valueBytes);
        } else if (int[].class.isAssignableFrom(valueClass)) {
            this.value = (V)Property.getIntegerArray(this.valueBytes);
        } else if (Command.class.isAssignableFrom(valueClass)) {
            this.value = CommandResolver.resolve(this.valueBytes);
        } else if (Bytes.class.isAssignableFrom(valueClass)) {
            this.value = this.valueBytes;
        } else if (Byte.class.isAssignableFrom(valueClass)) {
            this.value = this.valueBytes.get(0);
        }
        this.valueClass = valueClass;
    }

    private V getValueWithReflection(Class<V> valueClass, Bytes valueBytes) throws CommandParseException {
        try {
            if (PropertyValueObject.class.isAssignableFrom(valueClass)) {
                Constructor<V> constructor = valueClass.getConstructor(Bytes.class);
                return constructor.newInstance(valueBytes);
            }
            Method method = valueClass.getMethod("fromByte", Byte.TYPE);
            return (V)method.invoke(null, valueBytes.get(0));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            AutoApiLogger.getLogger().warn(this.getDebugMessage(valueClass, valueBytes));
            e.printStackTrace();
            throw new IllegalArgumentException("Cannot instantiate value: " + valueClass + "\n" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            AutoApiLogger.getLogger().warn(this.getDebugMessage(valueClass, valueBytes));
            if (e.getCause() instanceof CommandParseException) {
                throw (CommandParseException)e.getCause();
            }
            e.printStackTrace();
            throw new CommandParseException("Value initialisation error");
        }
    }

    private String getDebugMessage(Class<V> valueClass, Bytes valueBytes) {
        return String.format("Failed parsing %s, bytes %s", valueClass.getName(), valueBytes);
    }

    public static Bytes getBytes(Object value) {
        if (value instanceof PropertyValueObject) {
            return (PropertyValueObject)((Object)value);
        }
        if (value instanceof ByteEnum) {
            byte byteValue = ((ByteEnum)value).getByte();
            return new Bytes(new byte[]{byteValue});
        }
        if (value instanceof Boolean) {
            return new Bytes(new byte[]{Property.boolToByte((Boolean)value)});
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                return new Bytes(Property.floatToBytes(((Float)value).floatValue()));
            }
            if (value instanceof Integer) {
                return new Bytes(Property.intToBytes((Integer)value, 4));
            }
            if (value instanceof Double) {
                return new Bytes(Property.doubleToBytes((Double)value));
            }
            if (value instanceof Byte) {
                return new Bytes(new byte[]{(Byte)value});
            }
        } else {
            if (value instanceof String) {
                return new Bytes(Property.stringToBytes((String)value));
            }
            if (value instanceof Calendar) {
                return new Bytes(Property.calendarToBytes((Calendar)value));
            }
            if (value instanceof int[]) {
                return Property.integerArrayToBytes((int[])value);
            }
            if (value instanceof Command) {
                return (Command)((Object)value);
            }
            if (value instanceof Bytes) {
                return (Bytes)value;
            }
            throw new IllegalArgumentException("Type " + (value != null ? value.getClass() : "null") + " not supported for Property");
        }
        return null;
    }
}

