/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.property;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyComponentValue;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class PropertyInteger
extends Property<Integer> {
    boolean signed;

    public PropertyInteger(Integer value) {
        super(value);
    }

    public PropertyInteger(byte identifier, boolean signed, int length, Property<Integer> value) {
        super(Integer.class, identifier);
        this.failure = value.failure;
        this.timestamp = value.timestamp;
        Integer intValue = null;
        if (value.value != null) {
            intValue = (Integer)value.value.value;
        }
        this.update(signed, length, intValue);
    }

    public PropertyInteger(int identifier, boolean signed, int length, Property<Integer> value) {
        this((byte)identifier, signed, length, value);
    }

    public PropertyInteger(byte identifier, boolean signed) {
        super(Integer.class, identifier);
        this.signed = signed;
    }

    public PropertyInteger(int identifier, boolean signed) {
        this((byte)identifier, signed);
    }

    @Override
    public Property update(Property p) throws CommandParseException {
        super.update(p);
        if (p.getValueComponent() != null && this.value != null && p.getValueComponent().getValueBytes().getLength() >= 1) {
            this.value.value = this.signed ? Integer.valueOf(PropertyInteger.getSignedInt(p.getValueComponent().getValueBytes())) : Integer.valueOf(PropertyInteger.getUnsignedInt(p.getValueComponent().getValueBytes()));
        }
        return this;
    }

    public Property update(boolean signed, int newLength, @Nullable Integer value) {
        this.signed = signed;
        if (value != null) {
            this.value = new PropertyComponentValueInteger(value, signed, newLength);
            this.createBytesFromComponents(this.bytes[0]);
        }
        return this;
    }

    private static class PropertyComponentValueInteger
    extends PropertyComponentValue<Integer> {
        PropertyComponentValueInteger(Integer value, boolean signed, int newLength) {
            super((byte)1, newLength);
            this.valueBytes = new Bytes(Property.intToBytes(value, newLength));
            this.set(3, this.valueBytes);
            this.value = value;
        }
    }
}

