/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.AccelerationUnit;
import com.highmobility.value.Bytes;

public class Acceleration
extends PropertyValueObject {
    public static final int SIZE = 11;
    Direction direction;
    AccelerationUnit acceleration;

    public Direction getDirection() {
        return this.direction;
    }

    public AccelerationUnit getAcceleration() {
        return this.acceleration;
    }

    public Acceleration(Direction direction, AccelerationUnit acceleration) {
        super(0);
        this.direction = direction;
        this.acceleration = acceleration;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, direction.getByte());
        this.set(++bytePosition, acceleration);
    }

    public Acceleration(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.direction = Direction.fromByte(this.get(bytePosition));
        int accelerationSize = 10;
        this.acceleration = new AccelerationUnit(this.getRange(++bytePosition, bytePosition + accelerationSize));
    }

    public int getLength() {
        return 11;
    }

    public static enum Direction implements ByteEnum
    {
        LONGITUDINAL(0),
        LATERAL(1),
        FRONT_LATERAL(2),
        REAR_LATERAL(3);

        private final byte value;

        public static Direction fromByte(byte byteValue) throws CommandParseException {
            Direction[] values = Direction.values();
            for (int i = 0; i < values.length; ++i) {
                Direction state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Direction.class.getSimpleName(), byteValue));
        }

        private Direction(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

