/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.value.Bytes;

public class AccelerationDuration
extends PropertyValueObject {
    public static final int SIZE = 12;
    Direction direction;
    Type type;
    Duration duration;

    public Direction getDirection() {
        return this.direction;
    }

    public Type getType() {
        return this.type;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public AccelerationDuration(Direction direction, Type type, Duration duration) {
        super(0);
        this.direction = direction;
        this.type = type;
        this.duration = duration;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, direction.getByte());
        this.set(++bytePosition, type.getByte());
        this.set(++bytePosition, duration);
    }

    public AccelerationDuration(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 12) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.direction = Direction.fromByte(this.get(bytePosition));
        this.type = Type.fromByte(this.get(++bytePosition));
        int durationSize = 10;
        this.duration = new Duration(this.getRange(++bytePosition, bytePosition + durationSize));
    }

    public int getLength() {
        return 12;
    }

    public static enum Direction implements ByteEnum
    {
        LONGITUDINAL(0),
        LATERAL(1);

        private final byte value;

        public static Direction fromByte(byte byteValue) throws CommandParseException {
            Direction[] values = Direction.values();
            for (int i = 0; i < values.length; ++i) {
                Direction state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Direction.class.getSimpleName(), byteValue));
        }

        private Direction(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Type implements ByteEnum
    {
        REGULAR(0),
        POSITIVE_OUTLIER(1),
        NEGATIVE_OUTLIER(2);

        private final byte value;

        public static Type fromByte(byte byteValue) throws CommandParseException {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                Type state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Type.class.getSimpleName(), byteValue));
        }

        private Type(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

