/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.value.Bytes;

public class AcceleratorDuration
extends PropertyValueObject {
    public static final int SIZE = 18;
    Double pedalPositionThreshold;
    Duration duration;

    public Double getPedalPositionThreshold() {
        return this.pedalPositionThreshold;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public AcceleratorDuration(Double pedalPositionThreshold, Duration duration) {
        super(0);
        this.pedalPositionThreshold = pedalPositionThreshold;
        this.duration = duration;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.doubleToBytes(pedalPositionThreshold));
        this.set(bytePosition += 8, duration);
    }

    public AcceleratorDuration(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 18) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.pedalPositionThreshold = Property.getDouble(this.bytes, bytePosition);
        int durationSize = 10;
        this.duration = new Duration(this.getRange(bytePosition += 8, bytePosition + durationSize));
    }

    public int getLength() {
        return 18;
    }
}

