/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ActionItem
extends PropertyValueObject {
    Integer id;
    String name;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ActionItem(Integer id, String name) {
        super(0);
        this.id = id;
        this.name = name;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(id, 1));
        this.set(++bytePosition, Property.intToBytes(Property.getUtf8Length(name), 2));
        this.set(bytePosition += 2, Property.stringToBytes(name));
    }

    public ActionItem(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.id = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        int nameSize = this.getItemSize(++bytePosition);
        this.name = Property.getString(this.bytes, bytePosition += 2, nameSize);
    }

    public int getLength() {
        return 1 + Property.getUtf8Length(this.name) + 2;
    }
}

