/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class AddressComponent
extends PropertyValueObject {
    Type type;
    String value;

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public AddressComponent(Type type, String value) {
        super(0);
        this.type = type;
        this.value = value;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, type.getByte());
        this.set(++bytePosition, Property.intToBytes(Property.getUtf8Length(value), 2));
        this.set(bytePosition += 2, Property.stringToBytes(value));
    }

    public AddressComponent(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.type = Type.fromByte(this.get(bytePosition));
        int valueSize = this.getItemSize(++bytePosition);
        this.value = Property.getString(this.bytes, bytePosition += 2, valueSize);
    }

    public int getLength() {
        return 1 + Property.getUtf8Length(this.value) + 2;
    }

    public static enum Type implements ByteEnum
    {
        CITY(0),
        COUNTRY(1),
        COUNTRY_SHORT(2),
        DISTRICT(3),
        POSTAL_CODE(4),
        STREET(5),
        STATE_PROVINCE(6),
        OTHER(7);

        private final byte value;

        public static Type fromByte(byte byteValue) throws CommandParseException {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                Type state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Type.class.getSimpleName(), byteValue));
        }

        private Type(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

