/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class ChargingPoint
extends PropertyValueObject {
    String city;
    String postalCode;
    String street;
    String provider;

    public String getCity() {
        return this.city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getStreet() {
        return this.street;
    }

    public String getProvider() {
        return this.provider;
    }

    public ChargingPoint(String city, String postalCode, String street, String provider) {
        super(0);
        this.city = city;
        this.postalCode = postalCode;
        this.street = street;
        this.provider = provider;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(city), 2));
        this.set(bytePosition += 2, Property.stringToBytes(city));
        this.set(bytePosition += Property.getUtf8Length(city), Property.intToBytes(Property.getUtf8Length(postalCode), 2));
        this.set(bytePosition += 2, Property.stringToBytes(postalCode));
        this.set(bytePosition += Property.getUtf8Length(postalCode), Property.intToBytes(Property.getUtf8Length(street), 2));
        this.set(bytePosition += 2, Property.stringToBytes(street));
        this.set(bytePosition += Property.getUtf8Length(street), Property.intToBytes(Property.getUtf8Length(provider), 2));
        this.set(bytePosition += 2, Property.stringToBytes(provider));
    }

    public ChargingPoint(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 8) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int citySize = this.getItemSize(bytePosition);
        this.city = Property.getString(this.bytes, bytePosition += 2, citySize);
        int postalCodeSize = this.getItemSize(bytePosition += citySize);
        this.postalCode = Property.getString(this.bytes, bytePosition += 2, postalCodeSize);
        int streetSize = this.getItemSize(bytePosition += postalCodeSize);
        this.street = Property.getString(this.bytes, bytePosition += 2, streetSize);
        int providerSize = this.getItemSize(bytePosition += streetSize);
        this.provider = Property.getString(this.bytes, bytePosition += 2, providerSize);
    }

    public int getLength() {
        return Property.getUtf8Length(this.city) + 2 + Property.getUtf8Length(this.postalCode) + 2 + Property.getUtf8Length(this.street) + 2 + Property.getUtf8Length(this.provider) + 2;
    }
}

