/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class Coordinates
extends PropertyValueObject {
    public static final int SIZE = 16;
    Double latitude;
    Double longitude;

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Coordinates(Double latitude, Double longitude) {
        super(0);
        this.latitude = latitude;
        this.longitude = longitude;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.doubleToBytes(latitude));
        this.set(bytePosition += 8, Property.doubleToBytes(longitude));
    }

    public Coordinates(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 16) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.latitude = Property.getDouble(this.bytes, bytePosition);
        this.longitude = Property.getDouble(this.bytes, bytePosition += 8);
    }

    public int getLength() {
        return 16;
    }
}

