/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.OnOffState;
import com.highmobility.value.Bytes;

public class DashboardLight
extends PropertyValueObject {
    public static final int SIZE = 2;
    Name name;
    OnOffState state;

    public Name getName() {
        return this.name;
    }

    public OnOffState getState() {
        return this.state;
    }

    public DashboardLight(Name name, OnOffState state) {
        super(0);
        this.name = name;
        this.state = state;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, name.getByte());
        this.set(++bytePosition, state.getByte());
    }

    public DashboardLight(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.name = Name.fromByte(this.get(bytePosition));
        this.state = OnOffState.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Name implements ByteEnum
    {
        HIGH_BEAM(0),
        LOW_BEAM(1),
        HAZARD_WARNING(2),
        BRAKE_FAILURE(3),
        HATCH_OPEN(4),
        FUEL_LEVEL(5),
        ENGINE_COOLANT_TEMPERATURE(6),
        BATTERY_CHARGING_CONDITION(7),
        ENGINE_OIL(8),
        POSITION_LIGHTS(9),
        FRONT_FOG_LIGHT(10),
        REAR_FOG_LIGHT(11),
        PARK_HEATING(12),
        ENGINE_INDICATOR(13),
        SERVICE_CALL(14),
        TRANSMISSION_FLUID_TEMPERATURE(15),
        TRANSMISSION_FAILURE(16),
        ANTI_LOCK_BRAKE_FAILURE(17),
        WORN_BRAKE_LININGS(18),
        WINDSCREEN_WASHER_FLUID(19),
        TIRE_FAILURE(20),
        ENGINE_OIL_LEVEL(21),
        ENGINE_COOLANT_LEVEL(22),
        STEERING_FAILURE(23),
        ESC_INDICATION(24),
        BRAKE_LIGHTS(25),
        ADBLUE_LEVEL(26),
        FUEL_FILTER_DIFF_PRESSURE(27),
        SEAT_BELT(28),
        ADVANCED_BRAKING(29),
        ACC(30),
        TRAILER_CONNECTED(31),
        AIRBAG(32),
        ESC_SWITCHED_OFF(33),
        LANE_DEPARTURE_WARNING_OFF(34),
        AIR_FILTER_MINDER(35),
        AIR_SUSPENSION_RIDE_CONTROL_FAULT(36),
        ALL_WHEEL_DRIVE_DISABLED(37),
        ANTI_THEFT(38),
        BLIND_SPOT_DETECTION(39),
        CHARGE_SYSTEM_FAULT(40),
        CHECK_FUEL_CAP(41),
        CHECK_FUEL_FILL_INLET(42),
        CHECK_FUEL_FILTER(43),
        DC_TEMP_WARNING(44),
        DC_WARNING_STATUS(45),
        DIESEL_ENGINE_IDLE_SHUTDOWN(46),
        DIESEL_ENGINE_WARNING(47),
        DIESEL_EXHAUST_FLUID_SYSTEM_FAULT(48),
        DIESEL_EXHAUST_OVER_TEMP(49),
        DIESEL_EXHAUST_FLUID_QUALITY(50),
        DIESEL_FILTER_REGENERATION(51),
        DIESEL_PARTICULATE_FILTER(52),
        DIESEL_PRE_HEAT(53),
        ELECTRIC_TRAILER_BRAKE_CONNECTION(54),
        EV_BATTERY_CELL_MAX_VOLT_WARNING(55),
        EV_BATTERY_CELL_MIN_VOLT_WARNING(56),
        EV_BATTERY_CHARGE_ENERGY_STORAGE_WARNING(57),
        EV_BATTERY_HIGH_LEVEL_WARNING(58),
        EV_BATTERY_HIGH_TEMPERATURE_WARNING(59),
        EV_BATTERY_INSULATION_RESIST_WARNING(60),
        EV_BATTERY_JUMP_LEVEL_WARNING(61),
        EV_BATTERY_LOW_LEVEL_WARNING(62),
        EV_BATTERY_MAX_VOLT_VEH_ENERGY_WARNING(63),
        EV_BATTERY_MIN_VOLT_VEH_ENERGY_WARNING(64),
        EV_BATTERY_OVER_CHARGE_WARNING(65),
        EV_BATTERY_POOR_CELL_WARNING(66),
        EV_BATTERY_TEMP_DIFF_WARNING(67),
        FORWARD_COLLISION_WARNING(68),
        FUEL_DOOR_OPEN(69),
        HILL_DESCENT_CONTROL_FAULT(70),
        HILL_START_ASSIST_WARNING(71),
        HV_INTERLOCKING_STATUS_WARNING(72),
        LIGHTING_SYSTEM_FAILURE(73),
        MALFUNCTION_INDICATOR(74),
        MOTOR_CONTROLLER_TEMP_WARNING(75),
        PARK_AID_MALFUNCTION(76),
        PASSIVE_ENTRY_PASSIVE_START(77),
        POWERTRAIN_MALFUNCTION(78),
        RESTRAINTS_INDICATOR_WARNING(79),
        START_STOP_ENGINE_WARNING(80),
        TRACTION_CONTROL_DISABLED(81),
        TRACTION_CONTROL_ACTIVE(82),
        TRACTION_MOTOR_TEMP_WARNING(83),
        TIRE_PRESSURE_MONITOR_SYSTEM_WARNING(84),
        WATER_IN_FUEL(85),
        TIRE_WARNING_FRONT_RIGHT(86),
        TIRE_WARNING_FRONT_LEFT(87),
        TIRE_WARNING_REAR_RIGHT(88),
        TIRE_WARNING_REAR_LEFT(89),
        TIRE_WARNING_SYSTEM_ERROR(90),
        BATTERY_LOW_WARNING(91),
        BRAKE_FLUID_WARNING(92),
        ACTIVE_HOOD_FAULT(93),
        ACTIVE_SPOILER_FAULT(94),
        ADJUST_TIRE_PRESSURE(95),
        STEERING_LOCK_ALERT(96),
        ANTI_POLLUTION_FAILURE_ENGINE_START_IMPOSSIBLE(97),
        ANTI_POLLUTION_SYSTEM_FAILURE(98),
        ANTI_REVERSE_SYSTEM_FAILING(99),
        AUTO_PARKING_BRAKE(100),
        AUTOMATIC_BRAKING_DEACTIVE(101),
        AUTOMATIC_BRAKING_SYSTEM_FAULT(102),
        AUTOMATIC_LIGHTS_SETTINGS_FAILURE(103),
        KEYFOB_BATTERY_ALARM(104),
        TRUNK_OPEN(105),
        CHECK_REVERSING_LAMP(106),
        CROSSING_LINE_SYSTEM_ALERT_FAILURE(107),
        DIPPED_BEAM_HEADLAMPS_FRONT_LEFT_FAILURE(108),
        DIPPED_BEAM_HEADLAMPS_FRONT_RIGHT_FAILURE(109),
        DIRECTIONAL_HEADLAMPS_FAILURE(110),
        DIRECTIONAL_LIGHT_FAILURE(111),
        DSG_FAILING(112),
        ELECTRIC_MODE_NOT_AVAILABLE(113),
        ELECTRONIC_LOCK_FAILURE(114),
        ENGINE_CONTROL_SYSTEM_FAILURE(115),
        ENGINE_OIL_PRESSURE_ALERT(116),
        ESP_FAILURE(117),
        EXCESSIVE_OIL_TEMPERATURE(118),
        TIRE_FRONT_LEFT_FLAT(119),
        TIRE_FRONT_RIGHT_FLAT(120),
        TIRE_REAR_LEFT_FLAT(121),
        TIRE_REAR_RIGHT_FLAT(122),
        FOG_LIGHT_FRONT_LEFT_FAILURE(123),
        FOG_LIGHT_FRONT_RIGHT_FAILURE(124),
        FOG_LIGHT_REAR_LEFT_FAILURE(125),
        FOG_LIGHT_REAR_RIGHT_FAILURE(126),
        FOG_LIGHT_FRONT_FAULT(127),
        DOOR_FRONT_LEFT_OPEN(-128),
        DOOR_FRONT_LEFT_OPEN_HIGH_SPEED(-127),
        TIRE_FRONT_LEFT_NOT_MONITORED(-126),
        DOOR_FRONT_RIGHT_OPEN(-125),
        DOOR_FRONT_RIGHT_OPEN_HIGH_SPEED(-124),
        TIRE_FRONT_RIGHT_NOT_MONITORED(-123),
        HEADLIGHTS_LEFT_FAILURE(-122),
        HEADLIGHTS_RIGHT_FAILURE(-121),
        HYBRID_SYSTEM_FAULT(-120),
        HYBRID_SYSTEM_FAULT_REPAIRED_VEHICLE(-119),
        HYDRAULIC_PRESSURE_OR_BRAKE_FUILD_INSUFFICIENT(-118),
        LANE_DEPARTURE_FAULT(-117),
        LIMITED_VISIBILITY_AIDS_CAMERA(-116),
        TIRE_PRESSURE_LOW(-115),
        MAINTENANCE_DATE_EXCEEDED(-114),
        MAINTENANCE_ODOMETER_EXCEEDED(-113),
        OTHER_FAILING_SYSTEM(-112),
        PARKING_BRAKE_CONTROL_FAILING(-111),
        PARKING_SPACE_MEASURING_SYSTEM_FAILURE(-110),
        PLACE_GEAR_TO_PARKING(-109),
        POWER_STEERING_ASSITANCE_FAILURE(-108),
        POWER_STEERING_FAILURE(-107),
        PREHEATING_DEACTIVATED_BATTERY_TOO_LOW(-106),
        PREHEATING_DEACTIVATED_FUEL_LEVEL_TOO_LOW(-105),
        PREHEATING_DEACTIVATED_BATTERY_SET_THE_CLOCK(-104),
        FOG_LIGHT_REAR_FAULT(-103),
        DOOR_REAR_LEFT_OPEN(-102),
        DOOR_REAR_LEFT_OPEN_HIGH_SPEED(-101),
        TIRE_REAR_LEFT_NOT_MONITORED(-100),
        DOOR_REAR_RIGHT_OPEN(-99),
        DOOR_REAR_RIGHT_OPEN_HIGH_SPEED(-98),
        TIRE_REAR_RIGHT_NOT_MONITORED(-97),
        SCREEN_REAR_OPEN(-96),
        RETRACTABLE_ROOF_MECHANISM_FAULT(-95),
        REVERSE_LIGHT_LEFT_FAILURE(-94),
        REVERSE_LIGHT_RIGHT_FAILURE(-93),
        RISK_OF_ICE(-92),
        ROOF_OPERATION_IMPOSSIBLE_APPLY_PARKING_BREAK(-91),
        ROOF_OPERATION_IMPOSSIBLE_APPLY_START_ENGINE(-90),
        ROOF_OPERATION_IMPOSSIBLE_TEMPERATURE_TOO_HIGH(-89),
        SEATBELT_PASSENGER_FRONT_RIGHT_UNBUCKLED(-88),
        SEATBELT_PASSENGER_REAR_LEFT_UNBUCKLED(-87),
        SEATBELT_PASSENGER_REAR_CENTER_UNBUCKLED(-86),
        SEATBELT_PASSENGER_REAR_RIGHT_UNBUCKLED(-85),
        BATTERY_SECONDARY_LOW(-84),
        SHOCK_SENSOR_FAILING(-83),
        SIDE_LIGHTS_FRONT_LEFT_FAILURE(-82),
        SIDE_LIGHTS_FRONT_RIGHT_FAILURE(-81),
        SIDE_LIGHTS_REAR_LEFT_FAILURE(-80),
        SIDE_LIGHTS_REAR_RIGHT_FAILURE(-79),
        SPARE_WHEEL_FITTER_DRIVING_AIDS_DEACTIVATED(-78),
        SPEED_CONTROL_FAILURE(-77),
        STOP_LIGHT_LEFT_FAILURE(-76),
        STOP_LIGHT_RIGHT_FAILURE(-75),
        SUSPENSION_FAILURE(-74),
        SUSPENSION_FAILURE_REDUCE_SPEED(-73),
        SUSPENSION_FAULT_LIMITED_TO_90KMH(-72),
        TIRE_PRESSURE_SENSOR_FAILURE(-71),
        TRUNK_OPEN_HIGH_SPEED(-70),
        TRUNK_WINDOW_OPEN(-69),
        TURN_SIGNAL_FRONT_LEFT_FAILURE(-68),
        TURN_SIGNAL_FRONT_RIGHT_FAILURE(-67),
        TURN_SIGNAL_REAR_LEFT_FAILURE(-66),
        TURN_SIGNAL_REAR_RIGHT_FAILURE(-65),
        TIRE_UNDER_INFLATION(-64),
        WHEEL_PRESSURE_FAULT(-63),
        OIL_CHANGE_WARNING(-62),
        INSPECTION_WARNING(-61),
        DIESEL_OIL_FILTER_WATER_PRESENCE(-60),
        ENGINE_DRAG_TORQUE_CONTROL_FAILURE(-59);

        private final byte value;

        public static Name fromByte(byte byteValue) throws CommandParseException {
            Name[] values = Name.values();
            for (int i = 0; i < values.length; ++i) {
                Name state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Name.class.getSimpleName(), byteValue));
        }

        private Name(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

