/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;

public class DistanceOverTime
extends PropertyValueObject {
    public static final int SIZE = 20;
    Length distance;
    Duration time;

    public Length getDistance() {
        return this.distance;
    }

    public Duration getTime() {
        return this.time;
    }

    public DistanceOverTime(Length distance, Duration time) {
        super(0);
        this.distance = distance;
        this.time = time;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, distance);
        this.set(bytePosition += distance.getLength(), time);
    }

    public DistanceOverTime(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 20) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int distanceSize = 10;
        this.distance = new Length(this.getRange(bytePosition, bytePosition + distanceSize));
        int timeSize = 10;
        this.time = new Duration(this.getRange(bytePosition += distanceSize, bytePosition + timeSize));
    }

    public int getLength() {
        return 20;
    }
}

