/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class DriverCardPresent
extends PropertyValueObject {
    public static final int SIZE = 2;
    Integer driverNumber;
    CardPresent cardPresent;

    public Integer getDriverNumber() {
        return this.driverNumber;
    }

    public CardPresent getCardPresent() {
        return this.cardPresent;
    }

    public DriverCardPresent(Integer driverNumber, CardPresent cardPresent) {
        super(0);
        this.driverNumber = driverNumber;
        this.cardPresent = cardPresent;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(driverNumber, 1));
        this.set(++bytePosition, cardPresent.getByte());
    }

    public DriverCardPresent(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.driverNumber = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.cardPresent = CardPresent.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum CardPresent implements ByteEnum
    {
        NOT_PRESENT(0),
        PRESENT(1);

        private final byte value;

        public static CardPresent fromByte(byte byteValue) throws CommandParseException {
            CardPresent[] values = CardPresent.values();
            for (int i = 0; i < values.length; ++i) {
                CardPresent state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(CardPresent.class.getSimpleName(), byteValue));
        }

        private CardPresent(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

