/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class DriverTimeState
extends PropertyValueObject {
    public static final int SIZE = 2;
    Integer driverNumber;
    TimeState timeState;

    public Integer getDriverNumber() {
        return this.driverNumber;
    }

    public TimeState getTimeState() {
        return this.timeState;
    }

    public DriverTimeState(Integer driverNumber, TimeState timeState) {
        super(0);
        this.driverNumber = driverNumber;
        this.timeState = timeState;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(driverNumber, 1));
        this.set(++bytePosition, timeState.getByte());
    }

    public DriverTimeState(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.driverNumber = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.timeState = TimeState.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum TimeState implements ByteEnum
    {
        NORMAL(0),
        FIFTEEN_MIN_BEFORE_FOUR(1),
        FOUR_REACHED(2),
        FIFTEEN_MIN_BEFORE_NINE(3),
        NINE_REACHED(4),
        FIFTEEN_MIN_BEFORE_SIXTEEN(5),
        SIXTEEN_REACHED(6);

        private final byte value;

        public static TimeState fromByte(byte byteValue) throws CommandParseException {
            TimeState[] values = TimeState.values();
            for (int i = 0; i < values.length; ++i) {
                TimeState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(TimeState.class.getSimpleName(), byteValue));
        }

        private TimeState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

