/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.DrivingMode;
import com.highmobility.value.Bytes;

public class DrivingModeActivationPeriod
extends PropertyValueObject {
    public static final int SIZE = 9;
    DrivingMode drivingMode;
    Double period;

    public DrivingMode getDrivingMode() {
        return this.drivingMode;
    }

    public Double getPeriod() {
        return this.period;
    }

    public DrivingModeActivationPeriod(DrivingMode drivingMode, Double period) {
        super(0);
        this.drivingMode = drivingMode;
        this.period = period;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, drivingMode.getByte());
        this.set(++bytePosition, Property.doubleToBytes(period));
    }

    public DrivingModeActivationPeriod(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 9) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.drivingMode = DrivingMode.fromByte(this.get(bytePosition));
        this.period = Property.getDouble(this.bytes, ++bytePosition);
    }

    public int getLength() {
        return 9;
    }
}

