/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class EcoDrivingThreshold
extends PropertyValueObject {
    public static final int SIZE = 9;
    Type type;
    Double value;

    public Type getType() {
        return this.type;
    }

    public Double getValue() {
        return this.value;
    }

    public EcoDrivingThreshold(Type type, Double value) {
        super(0);
        this.type = type;
        this.value = value;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, type.getByte());
        this.set(++bytePosition, Property.doubleToBytes(value));
    }

    public EcoDrivingThreshold(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 9) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.type = Type.fromByte(this.get(bytePosition));
        this.value = Property.getDouble(this.bytes, ++bytePosition);
    }

    public int getLength() {
        return 9;
    }

    public static enum Type implements ByteEnum
    {
        ZERO(0),
        ONE(1);

        private final byte value;

        public static Type fromByte(byte byteValue) throws CommandParseException {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                Type state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Type.class.getSimpleName(), byteValue));
        }

        private Type(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

