/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;

public enum Event implements ByteEnum
{
    PING(0),
    TRIP_STARTED(1),
    TRIP_ENDED(2),
    VEHICLE_LOCATION_CHANGED(3),
    AUTHORIZATION_CHANGED(4),
    TIRE_PRESSURE_CHANGED(5),
    SEAT_BELT_TRIGGERED(10),
    MAINTENANCE_CHANGED(11),
    DASHBOARD_LIGHTS_CHANGED(12),
    IGNITION_CHANGED(13),
    ACCIDENT_REPORTED(14),
    EMERGENCY_REPORTED(15),
    BREAKDOWN_REPORTED(16),
    BATTERY_GUARD_WARNING(17),
    ENGINE_CHANGED(18),
    FLEET_CLEARANCE_CHANGED(19);

    private final byte value;

    public static Event fromByte(byte byteValue) throws CommandParseException {
        Event[] values = Event.values();
        for (int i = 0; i < values.length; ++i) {
            Event state = values[i];
            if (state.getByte() != byteValue) continue;
            return state;
        }
        throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Event.class.getSimpleName(), byteValue));
    }

    private Event(byte value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        return this.value;
    }
}

