/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class HmkitVersion
extends PropertyValueObject {
    public static final int SIZE = 3;
    Integer major;
    Integer minor;
    Integer patch;

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public HmkitVersion(Integer major, Integer minor, Integer patch) {
        super(0);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(major, 1));
        this.set(++bytePosition, Property.intToBytes(minor, 1));
        this.set(++bytePosition, Property.intToBytes(patch, 1));
    }

    public HmkitVersion(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.major = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.minor = Property.getUnsignedInt(this.bytes, ++bytePosition, 1);
        this.patch = Property.getUnsignedInt(this.bytes, ++bytePosition, 1);
    }

    public int getLength() {
        return 3;
    }
}

