/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class KeyValue
extends PropertyValueObject {
    String key;
    String value;

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public KeyValue(String key, String value) {
        super(0);
        this.key = key;
        this.value = value;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(key), 2));
        this.set(bytePosition += 2, Property.stringToBytes(key));
        this.set(bytePosition += Property.getUtf8Length(key), Property.intToBytes(Property.getUtf8Length(value), 2));
        this.set(bytePosition += 2, Property.stringToBytes(value));
    }

    public KeyValue(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 4) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int keySize = this.getItemSize(bytePosition);
        this.key = Property.getString(this.bytes, bytePosition += 2, keySize);
        int valueSize = this.getItemSize(bytePosition += keySize);
        this.value = Property.getString(this.bytes, bytePosition += 2, valueSize);
    }

    public int getLength() {
        return Property.getUtf8Length(this.key) + 2 + Property.getUtf8Length(this.value) + 2;
    }
}

