/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.value.Bytes;

public class LaneKeepAssistState
extends PropertyValueObject {
    public static final int SIZE = 2;
    Location location;
    ActiveState state;

    public Location getLocation() {
        return this.location;
    }

    public ActiveState getState() {
        return this.state;
    }

    public LaneKeepAssistState(Location location, ActiveState state) {
        super(0);
        this.location = location;
        this.state = state;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, state.getByte());
    }

    public LaneKeepAssistState(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = Location.fromByte(this.get(bytePosition));
        this.state = ActiveState.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Location implements ByteEnum
    {
        LEFT(0),
        RIGHT(1);

        private final byte value;

        public static Location fromByte(byte byteValue) throws CommandParseException {
            Location[] values = Location.values();
            for (int i = 0; i < values.length; ++i) {
                Location state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Location.class.getSimpleName(), byteValue));
        }

        private Location(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

