/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.KeyValue;
import com.highmobility.value.Bytes;

public class OemTroubleCodeValue
extends PropertyValueObject {
    String ID;
    KeyValue keyValue;

    public String getID() {
        return this.ID;
    }

    public KeyValue getKeyValue() {
        return this.keyValue;
    }

    public OemTroubleCodeValue(String ID, KeyValue keyValue) {
        super(0);
        this.ID = ID;
        this.keyValue = keyValue;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(Property.getUtf8Length(ID), 2));
        this.set(bytePosition += 2, Property.stringToBytes(ID));
        this.set(bytePosition += Property.getUtf8Length(ID), Property.intToBytes(keyValue.getLength(), 2));
        this.set(bytePosition += 2, keyValue);
    }

    public OemTroubleCodeValue(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        int IDSize = this.getItemSize(bytePosition);
        this.ID = Property.getString(this.bytes, bytePosition += 2, IDSize);
        int keyValueSize = this.getItemSize(bytePosition += IDSize);
        this.keyValue = new KeyValue(this.getRange(bytePosition += 2, bytePosition + keyValueSize));
    }

    public int getLength() {
        return Property.getUtf8Length(this.ID) + 2 + this.keyValue.getLength() + 2;
    }
}

