/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class RgbColour
extends PropertyValueObject {
    public static final int SIZE = 3;
    Integer red;
    Integer green;
    Integer blue;

    public Integer getRed() {
        return this.red;
    }

    public Integer getGreen() {
        return this.green;
    }

    public Integer getBlue() {
        return this.blue;
    }

    public RgbColour(Integer red, Integer green, Integer blue) {
        super(0);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(red, 1));
        this.set(++bytePosition, Property.intToBytes(green, 1));
        this.set(++bytePosition, Property.intToBytes(blue, 1));
    }

    public RgbColour(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 3) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.red = Property.getUnsignedInt(this.bytes, bytePosition, 1);
        this.green = Property.getUnsignedInt(this.bytes, ++bytePosition, 1);
        this.blue = Property.getUnsignedInt(this.bytes, ++bytePosition, 1);
    }

    public int getLength() {
        return 3;
    }
}

