/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.SeatLocation;
import com.highmobility.value.Bytes;

public class SeatbeltState
extends PropertyValueObject {
    public static final int SIZE = 2;
    SeatLocation location;
    FastenedState fastenedState;

    public SeatLocation getLocation() {
        return this.location;
    }

    public FastenedState getFastenedState() {
        return this.fastenedState;
    }

    public SeatbeltState(SeatLocation location, FastenedState fastenedState) {
        super(0);
        this.location = location;
        this.fastenedState = fastenedState;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, fastenedState.getByte());
    }

    public SeatbeltState(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = SeatLocation.fromByte(this.get(bytePosition));
        this.fastenedState = FastenedState.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum FastenedState implements ByteEnum
    {
        NOT_FASTENED(0),
        FASTENED(1);

        private final byte value;

        public static FastenedState fromByte(byte byteValue) throws CommandParseException {
            FastenedState[] values = FastenedState.values();
            for (int i = 0; i < values.length; ++i) {
                FastenedState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(FastenedState.class.getSimpleName(), byteValue));
        }

        private FastenedState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

