/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.Axle;
import com.highmobility.autoapi.value.measurement.Torque;
import com.highmobility.value.Bytes;

public class SpringRate
extends PropertyValueObject {
    public static final int SIZE = 11;
    Axle axle;
    Torque springRate;

    public Axle getAxle() {
        return this.axle;
    }

    public Torque getSpringRate() {
        return this.springRate;
    }

    public SpringRate(Axle axle, Torque springRate) {
        super(0);
        this.axle = axle;
        this.springRate = springRate;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, axle.getByte());
        this.set(++bytePosition, springRate);
    }

    public SpringRate(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.axle = Axle.fromByte(this.get(bytePosition));
        int springRateSize = 10;
        this.springRate = new Torque(this.getRange(++bytePosition, bytePosition + springRateSize));
    }

    public int getLength() {
        return 11;
    }
}

