/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.value.Bytes;

public class SupportedCapability
extends PropertyValueObject {
    Integer capabilityID;
    Bytes supportedPropertyIDs;

    public Integer getCapabilityID() {
        return this.capabilityID;
    }

    public Bytes getSupportedPropertyIDs() {
        return this.supportedPropertyIDs;
    }

    public SupportedCapability(Integer capabilityID, Bytes supportedPropertyIDs) {
        super(0);
        this.capabilityID = capabilityID;
        this.supportedPropertyIDs = supportedPropertyIDs;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, Property.intToBytes(capabilityID, 2));
        this.set(bytePosition += 2, Property.intToBytes(supportedPropertyIDs.getLength(), 2));
        this.set(bytePosition += 2, supportedPropertyIDs);
    }

    public SupportedCapability(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.capabilityID = Property.getUnsignedInt(this.bytes, bytePosition, 2);
        int supportedPropertyIDsSize = this.getItemSize(bytePosition += 2);
        this.supportedPropertyIDs = this.getRange(bytePosition += 2, bytePosition + supportedPropertyIDsSize);
    }

    public int getLength() {
        return 2 + this.supportedPropertyIDs.getLength() + 2;
    }
}

