/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.LocationWheel;
import com.highmobility.autoapi.value.measurement.Pressure;
import com.highmobility.value.Bytes;

public class TirePressure
extends PropertyValueObject {
    public static final int SIZE = 11;
    LocationWheel location;
    Pressure pressure;

    public LocationWheel getLocation() {
        return this.location;
    }

    public Pressure getPressure() {
        return this.pressure;
    }

    public TirePressure(LocationWheel location, Pressure pressure) {
        super(0);
        this.location = location;
        this.pressure = pressure;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, pressure);
    }

    public TirePressure(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = LocationWheel.fromByte(this.get(bytePosition));
        int pressureSize = 10;
        this.pressure = new Pressure(this.getRange(++bytePosition, bytePosition + pressureSize));
    }

    public int getLength() {
        return 11;
    }
}

