/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.LocationWheel;
import com.highmobility.value.Bytes;

public class TirePressureStatus
extends PropertyValueObject {
    public static final int SIZE = 2;
    LocationWheel location;
    Status status;

    public LocationWheel getLocation() {
        return this.location;
    }

    public Status getStatus() {
        return this.status;
    }

    public TirePressureStatus(LocationWheel location, Status status) {
        super(0);
        this.location = location;
        this.status = status;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, status.getByte());
    }

    public TirePressureStatus(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 2) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = LocationWheel.fromByte(this.get(bytePosition));
        this.status = Status.fromByte(this.get(++bytePosition));
    }

    public int getLength() {
        return 2;
    }

    public static enum Status implements ByteEnum
    {
        NORMAL(0),
        LOW(1),
        ALERT(2),
        SOFT(3),
        DEFLATION(4);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }
}

