/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.LocationWheel;
import com.highmobility.autoapi.value.measurement.Temperature;
import com.highmobility.value.Bytes;

public class TireTemperature
extends PropertyValueObject {
    public static final int SIZE = 11;
    LocationWheel location;
    Temperature temperature;

    public LocationWheel getLocation() {
        return this.location;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public TireTemperature(LocationWheel location, Temperature temperature) {
        super(0);
        this.location = location;
        this.temperature = temperature;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, temperature);
    }

    public TireTemperature(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 11) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = LocationWheel.fromByte(this.get(bytePosition));
        int temperatureSize = 10;
        this.temperature = new Temperature(this.getRange(++bytePosition, bytePosition + temperatureSize));
    }

    public int getLength() {
        return 11;
    }
}

