/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.autoapi.value.WindowLocation;
import com.highmobility.value.Bytes;

public class WindowOpenPercentage
extends PropertyValueObject {
    public static final int SIZE = 9;
    WindowLocation location;
    Double openPercentage;

    public WindowLocation getLocation() {
        return this.location;
    }

    public Double getOpenPercentage() {
        return this.openPercentage;
    }

    public WindowOpenPercentage(WindowLocation location, Double openPercentage) {
        super(0);
        this.location = location;
        this.openPercentage = openPercentage;
        this.bytes = new byte[this.getLength()];
        int bytePosition = 0;
        this.set(bytePosition, location.getByte());
        this.set(++bytePosition, Property.doubleToBytes(openPercentage));
    }

    public WindowOpenPercentage(Bytes valueBytes) throws CommandParseException {
        super(valueBytes);
        if (this.bytes.length < 9) {
            throw new CommandParseException();
        }
        int bytePosition = 0;
        this.location = WindowLocation.fromByte(this.get(bytePosition));
        this.openPercentage = Property.getDouble(this.bytes, ++bytePosition);
    }

    public int getLength() {
        return 9;
    }
}

