/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi.value.measurement;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.property.PropertyValueObject;
import com.highmobility.utils.ByteUtils;
import com.highmobility.value.Bytes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/highmobility/autoapi/value/measurement/MeasurementType;", "Lcom/highmobility/autoapi/property/PropertyValueObject;", "()V", "valueBytes", "Lcom/highmobility/value/Bytes;", "measurementId", "", "(Lcom/highmobility/value/Bytes;B)V", "getLength", "", "Companion", "auto-api-java"})
public class MeasurementType
extends PropertyValueObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int SIZE = 10;

    public MeasurementType() {
        super(10);
    }

    public MeasurementType(@NotNull Bytes valueBytes, byte measurementId) {
        Intrinsics.checkNotNullParameter((Object)valueBytes, (String)"valueBytes");
        super(valueBytes);
        if (valueBytes.getLength() != this.getLength()) {
            throw new CommandParseException(valueBytes + ": Measurement type bytes length should be 10");
        }
        Byte by = valueBytes.get(0);
        if (!(by != null ? by == measurementId : false)) {
            throw new CommandParseException(valueBytes + ": Measurement type id is not " + ByteUtils.hexFromByte((byte)measurementId));
        }
    }

    public int getLength() {
        return 10;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/highmobility/autoapi/value/measurement/MeasurementType$Companion;", "", "()V", "SIZE", "", "auto-api-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

