/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.test;

import java.io.File;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class SdkIntegrationTestBase {
    protected boolean skipTests = true;
    private File configFile = null;

    protected boolean skipTests() {
        return this.skipTests;
    }

    public abstract String getConfigFilename();

    @BeforeClass
    public void setUpConfig() throws Exception, InterruptedException {
        this.configFile = new File(this.getConfigFilename());
        if (!this.configFile.exists()) {
            this.skipTests = true;
            System.out.println(String.format(">>> Configuration file %s not found, skipping tests.", this.configFile.getCanonicalPath()));
        } else {
            this.skipTests = false;
            System.setProperty("IBM_CREDENTIALS_FILE", this.getConfigFilename());
        }
    }

    @BeforeMethod
    public void shouldSkipTest() {
        if (this.skipTests()) {
            throw new SkipException("Skipping test...");
        }
    }
}

