/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1;

import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.IbmCloudCodeEngine;
import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.model.GetKubeconfigOptions;
import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.model.ListKubeconfigOptions;
import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.utils.TestUtilities;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.model.FileWithMetadata;
import com.ibm.cloud.sdk.core.util.EnvironmentUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@PrepareForTest(value={EnvironmentUtils.class})
@PowerMockIgnore(value={"javax.net.ssl.*", "org.mockito.*"})
public class IbmCloudCodeEngineTest
extends PowerMockTestCase {
    final HashMap<String, InputStream> mockStreamMap = TestUtilities.createMockStreamMap();
    final List<FileWithMetadata> mockListFileWithMetadata = TestUtilities.creatMockListFileWithMetadata();
    protected MockWebServer server;
    protected IbmCloudCodeEngine ibmCloudCodeEngineService;

    private Map<String, String> getTestProcessEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TESTSERVICE_AUTH_TYPE", "noAuth");
        return env;
    }

    public void constructClientService() throws Throwable {
        PowerMockito.spy(EnvironmentUtils.class);
        PowerMockito.when((Object)EnvironmentUtils.getenv()).thenReturn(this.getTestProcessEnvironment());
        String serviceName = "testService";
        this.ibmCloudCodeEngineService = IbmCloudCodeEngine.newInstance((String)"testService");
        String url = this.server.url("/").toString();
        this.ibmCloudCodeEngineService.setServiceUrl(url);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testConstructorWithNullAuthenticator() throws Throwable {
        String serviceName = "testService";
        new IbmCloudCodeEngine("testService", null);
    }

    @Test
    public void testListKubeconfigWOptions() throws Throwable {
        String mockResponseBody = "\"operationResponse\"";
        String listKubeconfigPath = "/namespaces/testString/config";
        this.server.enqueue(new MockResponse().setHeader("Content-type", (Object)"text/plain").setResponseCode(200).setBody(mockResponseBody));
        this.constructClientService();
        ListKubeconfigOptions listKubeconfigOptionsModel = new ListKubeconfigOptions.Builder().refreshToken("testString").id("testString").accept("text/plain").build();
        Response response = this.ibmCloudCodeEngineService.listKubeconfig(listKubeconfigOptionsModel).execute();
        Assert.assertNotNull((Object)response);
        String responseObj = (String)response.getResult();
        Assert.assertNotNull((Object)responseObj);
        RecordedRequest request = this.server.takeRequest();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((String)request.getHeader("Refresh-Token"), (String)"testString");
        Map<String, String> query = TestUtilities.parseQueryString(request);
        Assert.assertNull(query);
        String parsedPath = TestUtilities.parseReqPath(request);
        Assert.assertEquals((String)parsedPath, (String)listKubeconfigPath);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testListKubeconfigNoOptions() throws Throwable {
        this.constructClientService();
        this.server.enqueue(new MockResponse());
        this.ibmCloudCodeEngineService.listKubeconfig(null).execute();
    }

    @Test
    public void testGetKubeconfigWOptions() throws Throwable {
        String mockResponseBody = "\"operationResponse\"";
        String getKubeconfigPath = "/project/testString/config";
        this.server.enqueue(new MockResponse().setHeader("Content-type", (Object)"text/plain").setResponseCode(200).setBody(mockResponseBody));
        this.constructClientService();
        GetKubeconfigOptions getKubeconfigOptionsModel = new GetKubeconfigOptions.Builder().xDelegatedRefreshToken("testString").id("testString").accept("text/plain").build();
        Response response = this.ibmCloudCodeEngineService.getKubeconfig(getKubeconfigOptionsModel).execute();
        Assert.assertNotNull((Object)response);
        String responseObj = (String)response.getResult();
        Assert.assertNotNull((Object)responseObj);
        RecordedRequest request = this.server.takeRequest();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((String)request.getHeader("X-Delegated-Refresh-Token"), (String)"testString");
        Map<String, String> query = TestUtilities.parseQueryString(request);
        Assert.assertNull(query);
        String parsedPath = TestUtilities.parseReqPath(request);
        Assert.assertEquals((String)parsedPath, (String)getKubeconfigPath);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetKubeconfigNoOptions() throws Throwable {
        this.constructClientService();
        this.server.enqueue(new MockResponse());
        this.ibmCloudCodeEngineService.getKubeconfig(null).execute();
    }

    @BeforeMethod
    public void setUpMockServer() {
        try {
            this.server = new MockWebServer();
            this.server.start();
        }
        catch (IOException err) {
            Assert.fail((String)"Failed to instantiate mock web server");
        }
    }

    @AfterMethod
    public void tearDownMockServer() throws IOException {
        this.server.shutdown();
        this.ibmCloudCodeEngineService = null;
    }
}

