/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.utils;

import com.ibm.cloud.sdk.core.service.model.FileWithMetadata;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.RecordedRequest;

public class TestUtilities {
    public static Map<String, Object> createMockMap() {
        HashMap<String, Object> mockMap = new HashMap<String, Object>();
        mockMap.put("foo", "bar");
        return mockMap;
    }

    public static HashMap<String, InputStream> createMockStreamMap() {
        return new HashMap<String, InputStream>(){
            {
                this.put("key1", TestUtilities.createMockStream("This is a mock file."));
            }
        };
    }

    public static Map<String, String> parseQueryString(RecordedRequest req) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        try {
            HttpUrl requestUrl = req.getRequestUrl();
            if (requestUrl != null) {
                Set queryParamsNames = requestUrl.queryParameterNames();
                for (String p : queryParamsNames) {
                    List val = requestUrl.queryParameterValues(p);
                    if (val == null || val.isEmpty()) continue;
                    String joinedQuery = String.join((CharSequence)",", val);
                    queryMap.put(p, joinedQuery);
                }
            }
            if (queryMap.isEmpty()) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return queryMap;
    }

    public static String parseReqPath(RecordedRequest req) {
        String parsedPath = null;
        try {
            String fullPath = req.getPath();
            if (fullPath != null && !fullPath.isEmpty()) {
                parsedPath = fullPath.split("\\?", 2)[0];
            }
            if (parsedPath.isEmpty() || parsedPath == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return parsedPath;
    }

    public static String serialize(Object obj) {
        return GsonSingleton.getGson().toJson(obj);
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return (T)GsonSingleton.getGson().fromJson(json, clazz);
    }

    public static InputStream createMockStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    public static List<FileWithMetadata> creatMockListFileWithMetadata() {
        ArrayList<FileWithMetadata> list = new ArrayList<FileWithMetadata>();
        byte[] fileBytes = new byte[]{-34, -83, -66, -17};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
        FileWithMetadata.Builder builder = new FileWithMetadata.Builder();
        builder.data((InputStream)inputStream);
        FileWithMetadata fileWithMetadata = builder.build();
        list.add(fileWithMetadata);
        return list;
    }

    public static byte[] createMockByteArray(String bytes) {
        return bytes.getBytes();
    }

    public static Date createMockDate(String date) throws Exception {
        return new SimpleDateFormat("yyyy-MM-dd").parse(date);
    }

    public static Date createMockDateTime(String date) throws Exception {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(date);
    }
}

