/*
 * (C) Copyright IBM Corp. 2023.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.code_engine.code_engine.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * V1ContextRef.
 */
public class V1ContextRef extends GenericModel {

  protected V1Context context;
  protected String name;

  protected V1ContextRef() { }

  /**
   * Gets the context.
   *
   * @return the context
   */
  public V1Context getContext() {
    return context;
  }

  /**
   * Gets the name.
   *
   * @return the name
   */
  public String getName() {
    return name;
  }
}

