/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.BuildRunList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListBuildRunsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class BuildRunsPager {
    protected boolean hasNext;
    protected ListBuildRunsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected BuildRunsPager() {
    }

    public BuildRunsPager(CodeEngine client, ListBuildRunsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<BuildRun> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListBuildRunsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        BuildRunList result = (BuildRunList)((Object)this.client.listBuildRuns(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getBuildRuns();
    }

    public List<BuildRun> getAll() {
        ArrayList<BuildRun> results = new ArrayList<BuildRun>();
        while (this.hasNext()) {
            List<BuildRun> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

