/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevision;
import com.ibm.cloud.code_engine.code_engine.v2.model.AppRevisionList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListAppRevisionsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class AppRevisionsPager {
    protected boolean hasNext;
    protected ListAppRevisionsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected AppRevisionsPager() {
    }

    public AppRevisionsPager(CodeEngine client, ListAppRevisionsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<AppRevision> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListAppRevisionsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        AppRevisionList result = (AppRevisionList)((Object)this.client.listAppRevisions(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getRevisions();
    }

    public List<AppRevision> getAll() {
        ArrayList<AppRevision> results = new ArrayList<AppRevision>();
        while (this.hasNext()) {
            List<AppRevision> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

