/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.util.Map;

public class BuildPatch
extends GenericModel {
    @SerializedName(value="output_image")
    protected String outputImage;
    @SerializedName(value="output_secret")
    protected String outputSecret;
    @SerializedName(value="source_context_dir")
    protected String sourceContextDir;
    @SerializedName(value="source_revision")
    protected String sourceRevision;
    @SerializedName(value="source_secret")
    protected String sourceSecret;
    @SerializedName(value="source_type")
    protected String sourceType;
    @SerializedName(value="source_url")
    protected String sourceUrl;
    @SerializedName(value="strategy_size")
    protected String strategySize;
    @SerializedName(value="strategy_spec_file")
    protected String strategySpecFile;
    @SerializedName(value="strategy_type")
    protected String strategyType;
    protected Long timeout;

    protected BuildPatch() {
    }

    protected BuildPatch(Builder builder) {
        this.outputImage = builder.outputImage;
        this.outputSecret = builder.outputSecret;
        this.sourceContextDir = builder.sourceContextDir;
        this.sourceRevision = builder.sourceRevision;
        this.sourceSecret = builder.sourceSecret;
        this.sourceType = builder.sourceType;
        this.sourceUrl = builder.sourceUrl;
        this.strategySize = builder.strategySize;
        this.strategySpecFile = builder.strategySpecFile;
        this.strategyType = builder.strategyType;
        this.timeout = builder.timeout;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String outputImage() {
        return this.outputImage;
    }

    public String outputSecret() {
        return this.outputSecret;
    }

    public String sourceContextDir() {
        return this.sourceContextDir;
    }

    public String sourceRevision() {
        return this.sourceRevision;
    }

    public String sourceSecret() {
        return this.sourceSecret;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String sourceUrl() {
        return this.sourceUrl;
    }

    public String strategySize() {
        return this.strategySize;
    }

    public String strategySpecFile() {
        return this.strategySpecFile;
    }

    public String strategyType() {
        return this.strategyType;
    }

    public Long timeout() {
        return this.timeout;
    }

    public Map<String, Object> asPatch() {
        return (Map)GsonSingleton.getGson().fromJson(this.toString(), Map.class);
    }

    public static class Builder {
        private String outputImage;
        private String outputSecret;
        private String sourceContextDir;
        private String sourceRevision;
        private String sourceSecret;
        private String sourceType;
        private String sourceUrl;
        private String strategySize;
        private String strategySpecFile;
        private String strategyType;
        private Long timeout;

        private Builder(BuildPatch buildPatch) {
            this.outputImage = buildPatch.outputImage;
            this.outputSecret = buildPatch.outputSecret;
            this.sourceContextDir = buildPatch.sourceContextDir;
            this.sourceRevision = buildPatch.sourceRevision;
            this.sourceSecret = buildPatch.sourceSecret;
            this.sourceType = buildPatch.sourceType;
            this.sourceUrl = buildPatch.sourceUrl;
            this.strategySize = buildPatch.strategySize;
            this.strategySpecFile = buildPatch.strategySpecFile;
            this.strategyType = buildPatch.strategyType;
            this.timeout = buildPatch.timeout;
        }

        public Builder() {
        }

        public BuildPatch build() {
            return new BuildPatch(this);
        }

        public Builder outputImage(String outputImage) {
            this.outputImage = outputImage;
            return this;
        }

        public Builder outputSecret(String outputSecret) {
            this.outputSecret = outputSecret;
            return this;
        }

        public Builder sourceContextDir(String sourceContextDir) {
            this.sourceContextDir = sourceContextDir;
            return this;
        }

        public Builder sourceRevision(String sourceRevision) {
            this.sourceRevision = sourceRevision;
            return this;
        }

        public Builder sourceSecret(String sourceSecret) {
            this.sourceSecret = sourceSecret;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder strategySize(String strategySize) {
            this.strategySize = strategySize;
            return this;
        }

        public Builder strategySpecFile(String strategySpecFile) {
            this.strategySpecFile = strategySpecFile;
            return this;
        }

        public Builder strategyType(String strategyType) {
            this.strategyType = strategyType;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static interface StrategyType {
        public static final String DOCKERFILE = "dockerfile";
        public static final String BUILDPACKS = "buildpacks";
    }

    public static interface StrategySize {
        public static final String SMALL = "small";
        public static final String MEDIUM = "medium";
        public static final String LARGE = "large";
        public static final String XLARGE = "xlarge";
        public static final String XXLARGE = "xxlarge";
    }

    public static interface SourceType {
        public static final String LOCAL = "local";
        public static final String GIT = "git";
    }
}

