/*
 * (C) Copyright IBM Corp. 2024.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * Response model of a volume mount.
 */
public class VolumeMount extends GenericModel {

  /**
   * Specify the type of the volume mount. Allowed types are: 'config_map', 'secret'.
   */
  public interface Type {
    /** config_map. */
    String CONFIG_MAP = "config_map";
    /** secret. */
    String SECRET = "secret";
  }

  @SerializedName("mount_path")
  protected String mountPath;
  protected String name;
  protected String reference;
  protected String type;

  protected VolumeMount() { }

  /**
   * Gets the mountPath.
   *
   * The path that should be mounted.
   *
   * @return the mountPath
   */
  public String getMountPath() {
    return mountPath;
  }

  /**
   * Gets the name.
   *
   * The name of the mount.
   *
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * Gets the reference.
   *
   * The name of the referenced secret or config map.
   *
   * @return the reference
   */
  public String getReference() {
    return reference;
  }

  /**
   * Gets the type.
   *
   * Specify the type of the volume mount. Allowed types are: 'config_map', 'secret'.
   *
   * @return the type
   */
  public String getType() {
    return type;
  }
}

